/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.rest.RestStatus;

public class LicenseUtils {
    public static final String EXPIRED_FEATURE_METADATA = "es.license.expired.feature";

    public static ElasticsearchSecurityException newComplianceException(String feature) {
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("current license is non-compliant for [{}]", RestStatus.FORBIDDEN, feature);
        e.addMetadata(EXPIRED_FEATURE_METADATA, feature);
        return e;
    }

    public static boolean isLicenseExpiredException(ElasticsearchSecurityException exception) {
        return exception != null && exception.getMetadata(EXPIRED_FEATURE_METADATA) != null;
    }

    public static boolean licenseNeedsExtended(License license) {
        return License.LicenseType.isBasic(license.type()) && license.expiryDate() != LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS;
    }

    public static boolean signatureNeedsUpdate(License license, DiscoveryNodes currentNodes) {
        String typeName = license.type();
        return (License.LicenseType.isBasic(typeName) || License.LicenseType.isTrial(typeName)) && license.version() < 4 && LicenseUtils.compatibleLicenseVersion(currentNodes) >= 4;
    }

    public static int compatibleLicenseVersion(DiscoveryNodes currentNodes) {
        return LicenseUtils.getMaxLicenseVersion(currentNodes.getMinNodeVersion());
    }

    public static int getMaxLicenseVersion(Version version) {
        if (version != null && version.before(Version.V_7_6_0)) {
            return 4;
        }
        return 5;
    }
}

