/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ScriptContextStats
implements Writeable,
ToXContentFragment,
Comparable<ScriptContextStats> {
    private final String context;
    private final long compilations;
    private final TimeSeries compilationsHistory;
    private final long cacheEvictions;
    private final TimeSeries cacheEvictionsHistory;
    private final long compilationLimitTriggered;

    public ScriptContextStats(String context, long compilations, long cacheEvictions, long compilationLimitTriggered, TimeSeries compilationsHistory, TimeSeries cacheEvictionsHistory) {
        this.context = Objects.requireNonNull(context);
        this.compilations = compilations;
        this.cacheEvictions = cacheEvictions;
        this.compilationLimitTriggered = compilationLimitTriggered;
        this.compilationsHistory = compilationsHistory;
        this.cacheEvictionsHistory = cacheEvictionsHistory;
    }

    public ScriptContextStats(StreamInput in) throws IOException {
        this.context = in.readString();
        this.compilations = in.readVLong();
        this.cacheEvictions = in.readVLong();
        this.compilationLimitTriggered = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_8_0_0)) {
            this.compilationsHistory = new TimeSeries(in);
            this.cacheEvictionsHistory = new TimeSeries(in);
        } else {
            this.compilationsHistory = null;
            this.cacheEvictionsHistory = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.context);
        out.writeVLong(this.compilations);
        out.writeVLong(this.cacheEvictions);
        out.writeVLong(this.compilationLimitTriggered);
        if (out.getVersion().onOrAfter(Version.V_8_0_0)) {
            this.compilationsHistory.writeTo(out);
            this.cacheEvictionsHistory.writeTo(out);
        }
    }

    public String getContext() {
        return this.context;
    }

    public long getCompilations() {
        return this.compilations;
    }

    public TimeSeries getCompilationsHistory() {
        return this.compilationsHistory;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    public TimeSeries getCacheEvictionsHistory() {
        return this.cacheEvictionsHistory;
    }

    public long getCompilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("context", this.getContext());
        builder.field("compilations", this.getCompilations());
        TimeSeries series = this.getCompilationsHistory();
        if (series != null && !series.isEmpty()) {
            builder.startObject("compilations_history");
            series.toXContent(builder, params);
            builder.endObject();
        }
        builder.field("cache_evictions", this.getCacheEvictions());
        series = this.getCacheEvictionsHistory();
        if (series != null && !series.isEmpty()) {
            builder.startObject("cache_evictions_history");
            series.toXContent(builder, params);
            builder.endObject();
        }
        builder.field("compilation_limit_triggered", this.getCompilationLimitTriggered());
        builder.endObject();
        return builder;
    }

    @Override
    public int compareTo(ScriptContextStats o) {
        return this.context.compareTo(o.context);
    }

    public static class TimeSeries
    implements Writeable,
    ToXContentFragment {
        public final long fiveMinutes;
        public final long fifteenMinutes;
        public final long twentyFourHours;

        public TimeSeries() {
            this.fiveMinutes = 0L;
            this.fifteenMinutes = 0L;
            this.twentyFourHours = 0L;
        }

        public TimeSeries(long fiveMinutes, long fifteenMinutes, long twentyFourHours) {
            assert (fiveMinutes >= 0L);
            this.fiveMinutes = fiveMinutes;
            assert (fifteenMinutes >= fiveMinutes);
            this.fifteenMinutes = fifteenMinutes;
            assert (twentyFourHours >= fifteenMinutes);
            this.twentyFourHours = twentyFourHours;
        }

        public TimeSeries(StreamInput in) throws IOException {
            this.fiveMinutes = in.readVLong();
            this.fifteenMinutes = in.readVLong();
            this.twentyFourHours = in.readVLong();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("5m", this.fiveMinutes);
            builder.field("15m", this.fifteenMinutes);
            builder.field("24h", this.twentyFourHours);
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.fiveMinutes);
            out.writeVLong(this.fifteenMinutes);
            out.writeVLong(this.twentyFourHours);
        }

        public boolean isEmpty() {
            return this.twentyFourHours == 0L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeSeries that = (TimeSeries)o;
            return this.fiveMinutes == that.fiveMinutes && this.fifteenMinutes == that.fifteenMinutes && this.twentyFourHours == that.twentyFourHours;
        }

        public int hashCode() {
            return Objects.hash(this.fiveMinutes, this.fifteenMinutes, this.twentyFourHours);
        }
    }

    static final class Fields {
        static final String CONTEXT = "context";
        static final String COMPILATIONS = "compilations";
        static final String COMPILATIONS_HISTORY = "compilations_history";
        static final String CACHE_EVICTIONS = "cache_evictions";
        static final String CACHE_EVICTIONS_HISTORY = "cache_evictions_history";
        static final String COMPILATION_LIMIT_TRIGGERED = "compilation_limit_triggered";
        static final String FIVE_MINUTES = "5m";
        static final String FIFTEEN_MINUTES = "15m";
        static final String TWENTY_FOUR_HOURS = "24h";

        Fields() {
        }
    }
}

