/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongConsumer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;
import org.elasticsearch.search.aggregations.bucket.composite.TermsSortedDocsProducer;

class OrdinalValuesSource
extends SingleDimensionValuesSource<BytesRef> {
    private final LongConsumer breakerConsumer;
    private final CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc;
    private final Map<Integer, SortedSetDocValues> dvsLookup = new HashMap<Integer, SortedSetDocValues>();
    private SortedSetDocValues lookup;
    private int leafReaderOrd = -1;
    private LongArray valuesOrd;
    private ObjectArray<BytesRef> valuesUnmapped;
    private int numSlots = 0;
    private Long currentValueOrd;
    private BytesRef currentValueUnmapped;
    private Long afterValueOrd;
    private Long lastLookupOrd;
    private BytesRef lastLookupValue;

    OrdinalValuesSource(BigArrays bigArrays, LongConsumer breakerConsumer, MappedFieldType type, CheckedFunction<LeafReaderContext, SortedSetDocValues, IOException> docValuesFunc, DocValueFormat format, boolean missingBucket, MissingOrder missingOrder, int size, int reverseMul) {
        super(bigArrays, format, type, missingBucket, missingOrder, size, reverseMul);
        this.breakerConsumer = breakerConsumer;
        this.docValuesFunc = docValuesFunc;
        this.valuesOrd = bigArrays.newLongArray(Math.min(size, 100), false);
        this.valuesUnmapped = bigArrays.newObjectArray(Math.min(size, 100));
    }

    private boolean invariant() {
        assert ((long)this.numSlots <= this.valuesOrd.size() && this.valuesOrd.size() == this.valuesOrd.size());
        for (int i = 0; i < this.numSlots; ++i) {
            assert (this.ordAndValueConsistency(this.valuesOrd.get(i), this.valuesUnmapped.get(i)));
        }
        if (this.currentValueOrd != null) assert (this.ordAndValueConsistency(this.currentValueOrd, this.currentValueUnmapped));
        if (this.lastLookupOrd != null) assert (this.lastLookupOrd >= 0L && this.lastLookupValue != null);
        return true;
    }

    private boolean ordAndValueConsistency(long ordinal, BytesRef value) {
        block6: {
            assert (ordinal != Long.MIN_VALUE || this.missingBucket);
            assert ((ordinal == Long.MIN_VALUE || ordinal >= 0L) == (value == null));
            try {
                if (ordinal >= 0L) assert (this.lookup.lookupOrd(ordinal) != null);
                if (value != null) assert (this.lookup.lookupTerm(value) == ordinal);
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)e);
            }
        }
        return true;
    }

    @Override
    void copyCurrent(int slot) {
        this.numSlots = Math.max(this.numSlots, slot + 1);
        this.valuesOrd = this.bigArrays.grow(this.valuesOrd, (long)this.numSlots);
        this.valuesUnmapped = this.bigArrays.grow(this.valuesUnmapped, (long)this.numSlots);
        assert (this.currentValueUnmapped == null);
        this.valuesOrd.set(slot, this.currentValueOrd);
        this.setValueWithBreaking(slot, this.currentValueUnmapped);
    }

    private void setValueWithBreaking(long index, BytesRef newValue) {
        BytesRef previousValue;
        long previousSize;
        long newSize = newValue == null ? 0L : (long)newValue.length;
        long delta = newSize - (previousSize = (previousValue = this.valuesUnmapped.get(index)) == null ? 0L : (long)previousValue.length);
        if (delta != 0L) {
            this.breakerConsumer.accept(delta);
        }
        this.valuesUnmapped.set(index, newValue);
    }

    @Override
    int compare(int from, int to) {
        assert (from < this.numSlots && to < this.numSlots);
        return this.compareInternal(this.valuesOrd.get(from), this.valuesOrd.get(to), this.valuesUnmapped.get(from), this.valuesUnmapped.get(to));
    }

    @Override
    int compareCurrent(int slot) {
        assert (this.currentValueOrd != null);
        assert (slot < this.numSlots);
        return this.compareInternal(this.currentValueOrd, this.valuesOrd.get(slot), this.currentValueUnmapped, this.valuesUnmapped.get(slot));
    }

    @Override
    int compareCurrentWithAfter() {
        assert (this.currentValueOrd != null && this.afterValueOrd != null);
        return this.compareInternal(this.currentValueOrd, this.afterValueOrd, this.currentValueUnmapped, (BytesRef)this.afterValue);
    }

    @Override
    int hashCode(int slot) {
        assert (slot < this.numSlots);
        return Long.hashCode(this.valuesOrd.get(slot));
    }

    @Override
    int hashCodeCurrent() {
        assert (this.currentValueOrd != null);
        return Long.hashCode(this.currentValueOrd);
    }

    private int compareInternal(long ord1, long ord2, BytesRef bytesRef1, BytesRef bytesRef2) {
        if (ord1 >= 0L && ord2 >= 0L) {
            return Long.compare(ord1, ord2) * this.reverseMul;
        }
        if (ord1 == Long.MIN_VALUE || ord2 == Long.MIN_VALUE) {
            return Long.compare(ord1, ord2) * this.missingOrder.compareAnyValueToMissing(this.reverseMul);
        }
        if (ord1 < 0L && ord2 < 0L) {
            if (ord1 == ord2) {
                assert (bytesRef1 != null && bytesRef2 != null);
                return bytesRef1.compareTo(bytesRef2) * this.reverseMul;
            }
            return Long.compare(-ord1 - 1L, -ord2 - 1L) * this.reverseMul;
        }
        if (ord1 < 0L) {
            assert (ord1 < 0L && ord2 >= 0L);
            int cmp = Long.compare(-ord1 - 1L, ord2);
            if (cmp == 0) {
                return -1 * this.reverseMul;
            }
            return cmp * this.reverseMul;
        }
        assert (ord1 >= 0L && ord2 < 0L);
        int cmp = Long.compare(ord1, -ord2 - 1L);
        if (cmp == 0) {
            return this.reverseMul;
        }
        return cmp * this.reverseMul;
    }

    @Override
    void setAfter(Comparable<?> value) {
        assert (this.invariant());
        if (this.missingBucket && value == null) {
            this.afterValue = null;
            this.afterValueOrd = Long.MIN_VALUE;
        } else if (value.getClass() == String.class || this.missingBucket && this.fieldType == null) {
            this.afterValue = this.format.parseBytesRef(value.toString());
            this.afterValueOrd = null;
        } else {
            throw new IllegalArgumentException("invalid value, expected string, got " + value.getClass().getSimpleName());
        }
        assert (this.invariant());
    }

    @Override
    BytesRef toComparable(int slot) throws IOException {
        assert (slot < this.numSlots);
        long ord = this.valuesOrd.get(slot);
        if (ord == Long.MIN_VALUE) {
            assert (this.missingBucket);
            return null;
        }
        if (ord < 0L) {
            return this.valuesUnmapped.get(slot);
        }
        if (this.lastLookupOrd != null && ord == this.lastLookupOrd) {
            assert (ord >= 0L);
            return this.lastLookupValue;
        }
        assert (ord >= 0L);
        this.lastLookupOrd = ord;
        this.lastLookupValue = BytesRef.deepCopyOf(this.lookup.lookupOrd(ord));
        return this.lastLookupValue;
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        boolean leafReaderContextChanged;
        boolean bl = leafReaderContextChanged = context.ord != this.leafReaderOrd;
        assert (!leafReaderContextChanged || this.invariant());
        if (leafReaderContextChanged) {
            SortedSetDocValues newLookup = this.dvsLookup.computeIfAbsent(context.ord, k -> {
                try {
                    return this.docValuesFunc.apply(context);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.remapOrdinals(this.lookup, newLookup);
            this.lookup = newLookup;
            this.leafReaderOrd = context.ord;
        }
        final SortedSetDocValues it = this.docValuesFunc.apply(context);
        assert (!leafReaderContextChanged || this.invariant());
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (it.advanceExact(doc)) {
                    long ord;
                    while ((ord = it.nextOrd()) != -1L) {
                        OrdinalValuesSource.this.currentValueOrd = ord;
                        OrdinalValuesSource.this.currentValueUnmapped = null;
                        next.collect(doc, bucket);
                    }
                } else if (OrdinalValuesSource.this.missingBucket) {
                    OrdinalValuesSource.this.currentValueOrd = Long.MIN_VALUE;
                    OrdinalValuesSource.this.currentValueUnmapped = null;
                    next.collect(doc, bucket);
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable<BytesRef> value, LeafReaderContext context, LeafBucketCollector next) throws IOException {
        boolean leafReaderContextChanged;
        boolean bl = leafReaderContextChanged = context.ord != this.leafReaderOrd;
        assert (!leafReaderContextChanged || this.invariant());
        if (value.getClass() != BytesRef.class) {
            throw new IllegalArgumentException("Expected BytesRef, got " + value.getClass());
        }
        BytesRef term = (BytesRef)value;
        if (leafReaderContextChanged) {
            SortedSetDocValues newLookup = this.dvsLookup.computeIfAbsent(context.ord, k -> {
                try {
                    return this.docValuesFunc.apply(context);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.remapOrdinals(this.lookup, newLookup);
            this.lookup = newLookup;
        }
        this.currentValueOrd = this.lookup.lookupTerm(term);
        this.currentValueUnmapped = null;
        this.leafReaderOrd = context.ord;
        assert (this.currentValueOrd >= 0L);
        assert (!leafReaderContextChanged || this.invariant());
        return next;
    }

    private void remapOrdinals(SortedSetDocValues oldMapping, SortedSetDocValues newMapping) throws IOException {
        ArrayList<Slot> sorted = new ArrayList<Slot>();
        for (int i = 0; i < this.numSlots; ++i) {
            long ord = this.valuesOrd.get(i);
            if (ord == Long.MIN_VALUE) continue;
            sorted.add(new Slot(i, ord, ord < 0L ? this.valuesUnmapped.get(i) : null));
        }
        Collections.sort(sorted);
        long lastOldOrd = Long.MIN_VALUE;
        long lastNewOrd = Long.MIN_VALUE;
        BytesRef lastUnmapped = null;
        for (Slot slot : sorted) {
            long newOrd;
            long index = slot.index;
            long oldOrd = slot.ord;
            BytesRef unmapped = slot.unmapped;
            if (oldOrd >= 0L) {
                if (lastOldOrd == oldOrd) {
                    newOrd = lastNewOrd;
                    if (newOrd < 0L) {
                        this.setValueWithBreaking(index, lastUnmapped);
                    }
                } else {
                    BytesRef newVal = oldMapping.lookupOrd(oldOrd);
                    newOrd = newMapping.lookupTerm(newVal);
                    if (newOrd < 0L) {
                        this.setValueWithBreaking(index, BytesRef.deepCopyOf(newVal));
                    }
                }
            } else {
                assert (unmapped != null);
                newOrd = newMapping.lookupTerm(unmapped);
                if (newOrd >= 0L) {
                    this.setValueWithBreaking(index, null);
                }
            }
            lastOldOrd = oldOrd;
            lastNewOrd = newOrd;
            lastUnmapped = this.valuesUnmapped.get(index);
            this.valuesOrd.set(index, newOrd);
        }
        if (this.currentValueOrd != null && this.currentValueOrd != Long.MIN_VALUE) {
            long newOrd;
            if (this.currentValueOrd >= 0L) {
                BytesRef newVal = oldMapping.lookupOrd(this.currentValueOrd);
                newOrd = newMapping.lookupTerm(newVal);
                if (newOrd < 0L) {
                    this.currentValueUnmapped = BytesRef.deepCopyOf(newVal);
                }
            } else {
                newOrd = newMapping.lookupTerm(this.currentValueUnmapped);
                if (newOrd >= 0L) {
                    this.currentValueUnmapped = null;
                }
            }
            this.currentValueOrd = newOrd;
        }
        if (this.afterValue != null) {
            this.afterValueOrd = newMapping.lookupTerm((BytesRef)this.afterValue);
        }
        this.lastLookupOrd = null;
        this.lastLookupValue = null;
    }

    @Override
    public boolean requiresRehashingWhenSwitchingLeafReaders() {
        return true;
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        if (!this.checkIfSortedDocsIsApplicable(reader, this.fieldType) || !(this.fieldType instanceof StringFieldType) || query != null && query.getClass() != MatchAllDocsQuery.class) {
            return null;
        }
        return new TermsSortedDocsProducer(this.fieldType.name());
    }

    @Override
    public void close() {
        Releasables.close(this.valuesOrd, this.valuesUnmapped);
    }

    private static class Slot
    implements Comparable<Slot> {
        final int index;
        final long ord;
        final BytesRef unmapped;

        private Slot(int index, long ord, BytesRef unmapped) {
            assert (ord >= 0L || unmapped != null);
            this.index = index;
            this.ord = ord;
            this.unmapped = unmapped;
        }

        @Override
        public int compareTo(Slot other) {
            if (this.ord < 0L && this.ord == other.ord) {
                assert (this.unmapped != null && other.unmapped != null);
                return this.unmapped.compareTo(other.unmapped);
            }
            long norm1 = this.ord < 0L ? -this.ord - 1L : this.ord;
            long norm2 = other.ord < 0L ? -other.ord - 1L : other.ord;
            int cmp = Long.compare(norm1, norm2);
            return cmp == 0 ? Long.compare(this.ord, other.ord) : cmp;
        }
    }
}

