/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.Script;

public abstract class AbstractScriptFieldQuery<S extends AbstractFieldScript>
extends Query {
    protected static final float MATCH_COST = 9000.0f;
    private final Script script;
    private final String fieldName;
    private final Function<LeafReaderContext, S> scriptContextFunction;

    AbstractScriptFieldQuery(Script script, String fieldName, Function<LeafReaderContext, S> scriptContextFunction) {
        this.script = Objects.requireNonNull(script);
        this.fieldName = Objects.requireNonNull(fieldName);
        this.scriptContextFunction = scriptContextFunction;
    }

    final Function<LeafReaderContext, S> scriptContextFunction() {
        return this.scriptContextFunction;
    }

    final Script script() {
        return this.script;
    }

    final String fieldName() {
        return this.fieldName;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public Scorer scorer(LeafReaderContext ctx) {
                final AbstractFieldScript scriptContext = (AbstractFieldScript)AbstractScriptFieldQuery.this.scriptContextFunction.apply(ctx);
                DocIdSetIterator approximation = DocIdSetIterator.all(ctx.reader().maxDoc());
                TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                    @Override
                    public boolean matches() {
                        return AbstractScriptFieldQuery.this.matches(scriptContext, this.approximation.docID());
                    }

                    @Override
                    public float matchCost() {
                        return 9000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation constantExplanation = super.explain(context, doc);
                if (constantExplanation.isMatch()) {
                    return AbstractScriptFieldQuery.this.explainMatch(boost, constantExplanation.getDescription());
                }
                return constantExplanation;
            }
        };
    }

    protected abstract boolean matches(S var1, int var2);

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.script, this.fieldName);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        AbstractScriptFieldQuery other = (AbstractScriptFieldQuery)obj;
        return this.script.equals(other.script) && this.fieldName.equals(other.fieldName);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            visitor.visitLeaf(this);
        }
    }

    final Explanation explainMatch(float boost, String description) {
        return Explanation.match((Number)Float.valueOf(boost), description, Explanation.match((Number)Float.valueOf(boost), "boost * runtime_field_score", Explanation.match((Number)Float.valueOf(boost), "boost", new Explanation[0]), Explanation.match((Number)1.0, "runtime_field_score is always 1", new Explanation[0])));
    }
}

