/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots.sourceonly;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.internal.io.IOUtils;

public class SourceOnlySnapshot {
    private static final String FIELDS_INDEX_EXTENSION = "fdx";
    private static final String FIELDS_META_EXTENSION = "fdm";
    private final LinkedFilesDirectory targetDirectory;
    private final Supplier<Query> deleteByQuerySupplier;

    public SourceOnlySnapshot(LinkedFilesDirectory targetDirectory, Supplier<Query> deleteByQuerySupplier) {
        this.targetDirectory = targetDirectory;
        this.deleteByQuerySupplier = deleteByQuerySupplier;
    }

    public SourceOnlySnapshot(LinkedFilesDirectory targetDirectory) {
        this(targetDirectory, null);
    }

    public synchronized List<String> syncSnapshot(IndexCommit commit) throws IOException {
        String segmentFileName;
        long generation;
        HashMap<BytesRef, SegmentCommitInfo> existingSegments = new HashMap<BytesRef, SegmentCommitInfo>();
        if (Lucene.indexExists(this.targetDirectory.getWrapped())) {
            SegmentInfos existingsSegmentInfos = Lucene.readSegmentInfos(this.targetDirectory.getWrapped());
            for (SegmentCommitInfo info : existingsSegmentInfos) {
                existingSegments.put(new BytesRef(info.info.getId()), info);
            }
            generation = existingsSegmentInfos.getGeneration();
        } else {
            generation = 1L;
        }
        ArrayList<String> createdFiles = new ArrayList<String>();
        try (Lock writeLock = this.targetDirectory.obtainLock("write.lock");
             StandardDirectoryReader reader = (StandardDirectoryReader)DirectoryReader.open(commit);){
            SegmentInfos segmentInfos = reader.getSegmentInfos().clone();
            DirectoryReader wrappedReader = this.wrapReader(reader);
            ArrayList<SegmentCommitInfo> newInfos = new ArrayList<SegmentCommitInfo>();
            for (LeafReaderContext ctx : wrappedReader.leaves()) {
                LeafReader leafReader = ctx.reader();
                SegmentCommitInfo info = Lucene.segmentReader(leafReader).getSegmentInfo();
                LiveDocs liveDocs = this.getLiveDocs(leafReader);
                if (leafReader.numDocs() == 0) continue;
                SegmentCommitInfo newInfo = this.syncSegment(info, liveDocs, leafReader.getFieldInfos(), existingSegments, createdFiles);
                newInfos.add(newInfo);
            }
            segmentInfos.clear();
            segmentInfos.addAll(newInfos);
            segmentInfos.setNextWriteGeneration(Math.max(segmentInfos.getGeneration(), generation) + 1L);
            String pendingSegmentFileName = IndexFileNames.fileNameFromGeneration("pending_segments", "", segmentInfos.getGeneration());
            try (IndexOutput segnOutput = this.targetDirectory.createOutput(pendingSegmentFileName, IOContext.DEFAULT);){
                segmentInfos.write(segnOutput);
            }
            this.targetDirectory.sync(Collections.singleton(pendingSegmentFileName));
            this.targetDirectory.sync(createdFiles);
            segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", segmentInfos.getGeneration());
            this.targetDirectory.rename(pendingSegmentFileName, segmentFileName);
        }
        Lucene.pruneUnreferencedFiles(segmentFileName, this.targetDirectory);
        assert (this.assertCheckIndex());
        return Collections.unmodifiableList(createdFiles);
    }

    private LiveDocs getLiveDocs(LeafReader reader) throws IOException {
        if (this.deleteByQuerySupplier != null) {
            DocIdSetIterator iterator;
            Query query = this.deleteByQuerySupplier.get();
            IndexSearcher s = new IndexSearcher(reader);
            s.setQueryCache(null);
            Query rewrite = s.rewrite(query);
            Weight weight = s.createWeight(rewrite, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer scorer = weight.scorer(reader.getContext());
            if (scorer != null && (iterator = scorer.iterator()) != null) {
                FixedBitSet bits;
                Bits liveDocs = reader.getLiveDocs();
                if (liveDocs != null) {
                    bits = FixedBitSet.copyOf(liveDocs);
                } else {
                    bits = new FixedBitSet(reader.maxDoc());
                    bits.set(0, reader.maxDoc());
                }
                int newDeletes = this.apply(iterator, bits);
                if (newDeletes != 0) {
                    int numDeletes = reader.numDeletedDocs() + newDeletes;
                    return new LiveDocs(numDeletes, bits);
                }
            }
        }
        return new LiveDocs(reader.numDeletedDocs(), reader.getLiveDocs());
    }

    private int apply(DocIdSetIterator iterator, FixedBitSet bits) throws IOException {
        int docID = -1;
        int newDeletes = 0;
        while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
            if (!bits.get(docID)) continue;
            bits.clear(docID);
            ++newDeletes;
        }
        return newDeletes;
    }

    private boolean assertCheckIndex() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        try (CheckIndex checkIndex = new CheckIndex(this.targetDirectory);){
            checkIndex.setFailFast(true);
            checkIndex.setInfoStream(new PrintStream((OutputStream)output, false, IOUtils.UTF_8), false);
            CheckIndex.Status status = checkIndex.checkIndex();
            if (status == null || !status.clean) {
                throw new RuntimeException("CheckIndex failed: " + output.toString(IOUtils.UTF_8));
            }
            boolean bl = true;
            return bl;
        }
    }

    DirectoryReader wrapReader(DirectoryReader reader) throws IOException {
        String softDeletesField = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            String field = ctx.reader().getFieldInfos().getSoftDeletesField();
            if (field == null) continue;
            softDeletesField = field;
            break;
        }
        return softDeletesField == null ? reader : new SoftDeletesDirectoryReaderWrapper(reader, softDeletesField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentCommitInfo syncSegment(SegmentCommitInfo segmentCommitInfo, LiveDocs liveDocs, FieldInfos fieldInfos, Map<BytesRef, SegmentCommitInfo> existingSegments, List<String> createdFiles) throws IOException {
        SegmentCommitInfo segmentCommitInfo2;
        Directory toClose = null;
        try {
            SegmentCommitInfo newInfo;
            SegmentInfo si = segmentCommitInfo.info;
            Codec codec = si.getCodec();
            Directory sourceDir = si.dir;
            if (si.getUseCompoundFile()) {
                toClose = sourceDir = new LinkedFilesDirectory.CloseMePleaseWrapper(codec.compoundFormat().getCompoundReader(sourceDir, si, IOContext.DEFAULT));
            }
            String segmentSuffix = "";
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(this.targetDirectory);
            BytesRef segmentId = new BytesRef(si.getId());
            boolean exists = existingSegments.containsKey(segmentId);
            if (!exists) {
                SegmentInfo newSegmentInfo = new SegmentInfo(this.targetDirectory, si.getVersion(), si.getMinVersion(), si.name, si.maxDoc(), false, si.getCodec(), si.getDiagnostics(), si.getId(), si.getAttributes(), null);
                newInfo = new SegmentCommitInfo(newSegmentInfo, 0, 0, -1L, -1L, -1L, StringHelper.randomId());
                ArrayList<FieldInfo> fieldInfoCopy = new ArrayList<FieldInfo>(fieldInfos.size());
                for (FieldInfo fieldInfo : fieldInfos) {
                    fieldInfoCopy.add(new FieldInfo(fieldInfo.name, fieldInfo.number, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, fieldInfo.attributes(), 0, 0, 0, 0, VectorSimilarityFunction.EUCLIDEAN, fieldInfo.isSoftDeletesField()));
                }
                FieldInfos newFieldInfos = new FieldInfos(fieldInfoCopy.toArray(new FieldInfo[0]));
                codec.fieldInfosFormat().write(trackingDir, newSegmentInfo, "", newFieldInfos, IOContext.DEFAULT);
                newInfo.setFieldInfosFiles(trackingDir.getCreatedFiles());
            } else {
                newInfo = existingSegments.get(segmentId);
                assert (!newInfo.info.getUseCompoundFile());
            }
            String idxFile = IndexFileNames.segmentFileName(newInfo.info.name, "", FIELDS_INDEX_EXTENSION);
            String dataFile = IndexFileNames.segmentFileName(newInfo.info.name, "", "fdt");
            String metaFile = IndexFileNames.segmentFileName(newInfo.info.name, "", FIELDS_META_EXTENSION);
            trackingDir.copyFrom(sourceDir, idxFile, idxFile, IOContext.DEFAULT);
            assert (this.targetDirectory.linkedFiles.containsKey(idxFile));
            assert (trackingDir.getCreatedFiles().contains(idxFile));
            trackingDir.copyFrom(sourceDir, dataFile, dataFile, IOContext.DEFAULT);
            assert (this.targetDirectory.linkedFiles.containsKey(dataFile));
            assert (trackingDir.getCreatedFiles().contains(dataFile));
            if (Arrays.asList(sourceDir.listAll()).contains(metaFile)) {
                trackingDir.copyFrom(sourceDir, metaFile, metaFile, IOContext.DEFAULT);
                assert (this.targetDirectory.linkedFiles.containsKey(metaFile));
                assert (trackingDir.getCreatedFiles().contains(metaFile));
            }
            if (liveDocs.bits != null && liveDocs.numDeletes != 0 && liveDocs.numDeletes != newInfo.getDelCount()) {
                assert (newInfo.getDelCount() == 0 || this.assertLiveDocs(liveDocs.bits, liveDocs.numDeletes));
                codec.liveDocsFormat().writeLiveDocs(liveDocs.bits, trackingDir, newInfo, liveDocs.numDeletes - newInfo.getDelCount(), IOContext.DEFAULT);
                SegmentCommitInfo info = new SegmentCommitInfo(newInfo.info, liveDocs.numDeletes, 0, newInfo.getNextDelGen(), -1L, -1L, StringHelper.randomId());
                info.setFieldInfosFiles(newInfo.getFieldInfosFiles());
                info.info.setFiles(trackingDir.getCreatedFiles());
                newInfo = info;
            }
            if (!exists) {
                newInfo.info.setFiles(trackingDir.getCreatedFiles());
                codec.segmentInfoFormat().write(trackingDir, newInfo.info, IOContext.DEFAULT);
            }
            Set<String> createdFilesForThisSegment = trackingDir.getCreatedFiles();
            createdFilesForThisSegment.remove(idxFile);
            createdFilesForThisSegment.remove(dataFile);
            createdFilesForThisSegment.remove(metaFile);
            createdFiles.addAll(createdFilesForThisSegment);
            segmentCommitInfo2 = newInfo;
        }
        catch (Throwable throwable) {
            IOUtils.close(toClose);
            throw throwable;
        }
        IOUtils.close((Closeable)toClose);
        return segmentCommitInfo2;
    }

    private boolean assertLiveDocs(Bits liveDocs, int deletes) {
        int actualDeletes = 0;
        for (int i = 0; i < liveDocs.length(); ++i) {
            if (liveDocs.get(i)) continue;
            ++actualDeletes;
        }
        assert (actualDeletes == deletes) : " actual: " + actualDeletes + " deletes: " + deletes;
        return true;
    }

    public static class LinkedFilesDirectory
    extends Directory {
        private final Directory wrapped;
        private final Map<String, Directory> linkedFiles = new HashMap<String, Directory>();

        public LinkedFilesDirectory(Directory wrapped) {
            this.wrapped = wrapped;
        }

        public Directory getWrapped() {
            return this.wrapped;
        }

        @Override
        public String[] listAll() throws IOException {
            HashSet<String> files = new HashSet<String>();
            Collections.addAll(files, this.wrapped.listAll());
            files.addAll(this.linkedFiles.keySet());
            Object[] result = files.toArray(Strings.EMPTY_ARRAY);
            Arrays.sort(result);
            return result;
        }

        @Override
        public void deleteFile(String name) throws IOException {
            Directory directory = this.linkedFiles.remove(name);
            if (directory == null) {
                this.wrapped.deleteFile(name);
            } else {
                try (Directory directory2 = directory;){
                    this.wrapped.deleteFile(name);
                }
                catch (FileNotFoundException | NoSuchFileException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public long fileLength(String name) throws IOException {
            Directory linkedDir = this.linkedFiles.get(name);
            if (linkedDir != null) {
                return linkedDir.fileLength(name);
            }
            return this.wrapped.fileLength(name);
        }

        @Override
        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            if (this.linkedFiles.containsKey(name)) {
                throw new IllegalArgumentException("file cannot be created as linked file with name " + name + " already exists");
            }
            return this.wrapped.createOutput(name, context);
        }

        @Override
        public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
            return this.wrapped.createTempOutput(prefix, suffix, context);
        }

        @Override
        public void sync(Collection<String> names) throws IOException {
            ArrayList<String> primaryNames = new ArrayList<String>();
            for (String name : names) {
                if (this.linkedFiles.containsKey(name)) continue;
                primaryNames.add(name);
            }
            if (!primaryNames.isEmpty()) {
                this.wrapped.sync(primaryNames);
            }
        }

        @Override
        public void syncMetaData() throws IOException {
            this.wrapped.syncMetaData();
        }

        @Override
        public void rename(String source, String dest) throws IOException {
            if (this.linkedFiles.containsKey(source) || this.linkedFiles.containsKey(dest)) {
                throw new IllegalArgumentException("file cannot be renamed as linked file with name " + source + " or " + dest + " already exists");
            }
            this.wrapped.rename(source, dest);
        }

        @Override
        public IndexInput openInput(String name, IOContext context) throws IOException {
            Directory linkedDir = this.linkedFiles.get(name);
            if (linkedDir != null) {
                return linkedDir.openInput(name, context);
            }
            return this.wrapped.openInput(name, context);
        }

        @Override
        public Lock obtainLock(String name) throws IOException {
            return this.wrapped.obtainLock(name);
        }

        @Override
        public void close() throws IOException {
            Closeable[] closeableArray = new Closeable[3];
            closeableArray[0] = () -> IOUtils.close(this.linkedFiles.values());
            closeableArray[1] = this.linkedFiles::clear;
            closeableArray[2] = this.wrapped;
            IOUtils.close(closeableArray);
        }

        @Override
        public void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
            Directory previous;
            if (!src.equals(dest)) {
                throw new IllegalArgumentException();
            }
            if (from instanceof CloseMePleaseWrapper) {
                ((CloseMePleaseWrapper)from).incRef();
                previous = this.linkedFiles.put(src, from);
            } else {
                previous = this.linkedFiles.put(src, new FilterDirectory(from){

                    @Override
                    public void close() {
                    }
                });
            }
            IOUtils.close((Closeable)previous);
        }

        @Override
        public Set<String> getPendingDeletions() throws IOException {
            return this.wrapped.getPendingDeletions();
        }

        static class CloseMePleaseWrapper
        extends FilterDirectory {
            private final AtomicInteger refCount = new AtomicInteger(1);

            CloseMePleaseWrapper(Directory in) {
                super(in);
            }

            public void incRef() {
                int ref = this.refCount.incrementAndGet();
                assert (ref > 1);
            }

            @Override
            public void close() throws IOException {
                if (this.refCount.decrementAndGet() == 0) {
                    this.in.close();
                }
            }
        }
    }

    private static class LiveDocs {
        final int numDeletes;
        final Bits bits;

        LiveDocs(int numDeletes, Bits bits) {
            this.numDeletes = numDeletes;
            this.bits = bits;
        }
    }
}

