/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;

public abstract class AbstractTransportSetResetModeAction
extends AcknowledgedTransportMasterNodeAction<SetResetModeActionRequest> {
    private static final Logger logger = LogManager.getLogger(AbstractTransportSetResetModeAction.class);
    private final ClusterService clusterService;

    @Inject
    public AbstractTransportSetResetModeAction(String actionName, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, SetResetModeActionRequest::new, indexNameExpressionResolver, "same");
        this.clusterService = clusterService;
    }

    protected abstract boolean isResetMode(ClusterState var1);

    protected abstract String featureName();

    protected abstract ClusterState setState(ClusterState var1, SetResetModeActionRequest var2);

    @Override
    protected void masterOperation(Task task, final SetResetModeActionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        boolean isResetModeEnabled = this.isResetMode(state);
        if (request.isEnabled() == isResetModeEnabled) {
            logger.debug(() -> new ParameterizedMessage("Reset mode noop for [{}]", (Object)this.featureName()));
            listener.onResponse(AcknowledgedResponse.TRUE);
            return;
        }
        logger.debug(() -> new ParameterizedMessage("Starting to set [reset_mode] for [{}] to [{}] from [{}]", this.featureName(), request.isEnabled(), isResetModeEnabled));
        ActionListener<AcknowledgedResponse> wrappedListener = ActionListener.wrap(r -> {
            logger.debug(() -> new ParameterizedMessage("Completed reset mode request for [{}]", (Object)this.featureName()));
            listener.onResponse((AcknowledgedResponse)r);
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("Completed reset mode for [{}] request but with failure", (Object)this.featureName()), (Throwable)e);
            listener.onFailure((Exception)e);
        });
        ActionListener<AcknowledgedResponse> clusterStateUpdateListener = ActionListener.wrap(acknowledgedResponse -> {
            if (!acknowledgedResponse.isAcknowledged()) {
                wrappedListener.onFailure(new ElasticsearchTimeoutException("Unknown error occurred while updating cluster state", new Object[0]));
                return;
            }
            wrappedListener.onResponse((AcknowledgedResponse)acknowledgedResponse);
        }, wrappedListener::onFailure);
        this.clusterService.submitStateUpdateTask(this.featureName() + "-set-reset-mode", new AckedClusterStateUpdateTask(request, clusterStateUpdateListener){

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                logger.trace(() -> new ParameterizedMessage("Cluster update response built for [{}]: {}", (Object)AbstractTransportSetResetModeAction.this.featureName(), (Object)acknowledged));
                return AcknowledgedResponse.of(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                logger.trace(() -> new ParameterizedMessage("Executing cluster state update for [{}]", (Object)AbstractTransportSetResetModeAction.this.featureName()));
                return AbstractTransportSetResetModeAction.this.setState(currentState, request);
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(SetResetModeActionRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

