/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.async.AsyncResponse;

public class StoredAsyncResponse<R extends Writeable>
extends ActionResponse
implements AsyncResponse<StoredAsyncResponse<R>>,
ToXContentObject {
    private final R response;
    private final Exception exception;
    private final long expirationTimeMillis;

    public StoredAsyncResponse(R response, long expirationTimeMillis) {
        this(response, null, expirationTimeMillis);
    }

    public StoredAsyncResponse(Exception exception, long expirationTimeMillis) {
        this(null, exception, expirationTimeMillis);
    }

    public StoredAsyncResponse(Writeable.Reader<R> reader, StreamInput input) throws IOException {
        this.expirationTimeMillis = input.readLong();
        this.response = input.readOptionalWriteable(reader);
        this.exception = input.readException();
    }

    private StoredAsyncResponse(R response, Exception exception, long expirationTimeMillis) {
        this.response = response;
        this.exception = exception;
        this.expirationTimeMillis = expirationTimeMillis;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTimeMillis;
    }

    @Override
    public StoredAsyncResponse<R> withExpirationTime(long expirationTimeMillis) {
        return new StoredAsyncResponse<R>(this.response, this.exception, expirationTimeMillis);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.expirationTimeMillis);
        out.writeOptionalWriteable((Writeable)this.response);
        out.writeException(this.exception);
    }

    public R getResponse() {
        return this.response;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredAsyncResponse response1 = (StoredAsyncResponse)o;
        if (this.exception != null && response1.exception != null ? !Objects.equals(this.exception.getClass(), response1.exception.getClass()) || !Objects.equals(this.exception.getMessage(), response1.exception.getMessage()) : !Objects.equals(this.exception, response1.exception)) {
            return false;
        }
        return this.expirationTimeMillis == response1.expirationTimeMillis && Objects.equals(this.response, response1.response);
    }

    public int hashCode() {
        return Objects.hash(this.response, this.exception == null ? null : this.exception.getClass(), this.exception == null ? null : this.exception.getMessage(), this.expirationTimeMillis);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return null;
    }
}

