/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetRecordsAction
extends ActionType<Response> {
    public static final GetRecordsAction INSTANCE = new GetRecordsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/records/get";

    private GetRecordsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<AnomalyRecord>
    implements ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(QueryPage<AnomalyRecord> records) {
            super(records);
        }

        public QueryPage<AnomalyRecord> getRecords() {
            return this.getResources();
        }

        @Override
        protected Writeable.Reader<AnomalyRecord> getReader() {
            return AnomalyRecord::new;
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
        public static final ParseField RECORD_SCORE_FILTER = new ParseField("record_score", new String[0]);
        public static final ParseField SORT = new ParseField("sort", new String[0]);
        public static final ParseField DESCENDING = new ParseField("desc", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/records/get", Request::new);
        private String jobId;
        private String start;
        private String end;
        private boolean excludeInterim = false;
        private PageParams pageParams = new PageParams();
        private double recordScoreFilter = 0.0;
        private String sort = RECORD_SCORE_FILTER.getPreferredName();
        private boolean descending = true;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = PARSER.apply(parser, null);
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.excludeInterim = in.readBoolean();
            this.pageParams = new PageParams(in);
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.sort = in.readOptionalString();
            this.descending = in.readBoolean();
            this.recordScoreFilter = in.readDouble();
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public boolean isDescending() {
            return this.descending;
        }

        public void setDescending(boolean descending) {
            this.descending = descending;
        }

        public boolean isExcludeInterim() {
            return this.excludeInterim;
        }

        public void setExcludeInterim(boolean excludeInterim) {
            this.excludeInterim = excludeInterim;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = pageParams;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public double getRecordScoreFilter() {
            return this.recordScoreFilter;
        }

        public void setRecordScore(double recordScoreFilter) {
            this.recordScoreFilter = recordScoreFilter;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = ExceptionsHelper.requireNonNull(sort, SORT.getPreferredName());
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeBoolean(this.excludeInterim);
            this.pageParams.writeTo(out);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalString(this.sort);
            out.writeBoolean(this.descending);
            out.writeDouble(this.recordScoreFilter);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(START.getPreferredName(), this.start);
            builder.field(END.getPreferredName(), this.end);
            builder.field(SORT.getPreferredName(), this.sort);
            builder.field(DESCENDING.getPreferredName(), this.descending);
            builder.field(RECORD_SCORE_FILTER.getPreferredName(), this.recordScoreFilter);
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
            builder.field(PageParams.PAGE.getPreferredName(), this.pageParams);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.start, this.end, this.sort, this.descending, this.recordScoreFilter, this.excludeInterim, this.pageParams);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.sort, other.sort) && Objects.equals(this.descending, other.descending) && Objects.equals(this.recordScoreFilter, other.recordScoreFilter) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.pageParams, other.pageParams);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareStringOrNull(Request::setStart, START);
            PARSER.declareStringOrNull(Request::setEnd, END);
            PARSER.declareString(Request::setSort, SORT);
            PARSER.declareBoolean(Request::setDescending, DESCENDING);
            PARSER.declareBoolean(Request::setExcludeInterim, EXCLUDE_INTERIM);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
            PARSER.declareDouble(Request::setRecordScore, RECORD_SCORE_FILTER);
        }
    }
}

