/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationFields;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Accuracy;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.MulticlassConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Precision;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification.Recall;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Classification
implements Evaluation {
    public static final ParseField NAME = new ParseField("classification", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    private static final String DEFAULT_TOP_CLASSES_FIELD = "ml.top_classes";
    private static final String DEFAULT_PREDICTED_CLASS_FIELD_SUFFIX = ".class_name";
    private static final String DEFAULT_PREDICTED_PROBABILITY_FIELD_SUFFIX = ".class_probability";
    public static final ConstructingObjectParser<Classification, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new Classification((String)a[0], (String)a[1], (String)a[2], (List)a[3]));
    private final EvaluationFields fields;
    private final List<EvaluationMetric> metrics;

    public static Classification fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public Classification(String actualField, @Nullable String predictedField, @Nullable String topClassesField, @Nullable List<EvaluationMetric> metrics) {
        if (topClassesField == null) {
            topClassesField = DEFAULT_TOP_CLASSES_FIELD;
        }
        String predictedClassField = topClassesField + DEFAULT_PREDICTED_CLASS_FIELD_SUFFIX;
        String predictedProbabilityField = topClassesField + DEFAULT_PREDICTED_PROBABILITY_FIELD_SUFFIX;
        this.fields = new EvaluationFields(ExceptionsHelper.requireNonNull(actualField, EvaluationFields.ACTUAL_FIELD), predictedField, topClassesField, predictedClassField, predictedProbabilityField, true);
        this.metrics = this.initMetrics(metrics, Classification::defaultMetrics);
    }

    private static List<EvaluationMetric> defaultMetrics() {
        return Arrays.asList(new Accuracy(), new MulticlassConfusionMatrix(), new Precision(), new Recall());
    }

    public Classification(StreamInput in) throws IOException {
        this.fields = new EvaluationFields(in.readString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), true);
        this.metrics = in.readNamedWriteableList(EvaluationMetric.class);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public EvaluationFields getFields() {
        return this.fields;
    }

    public List<EvaluationMetric> getMetrics() {
        return this.metrics;
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fields.getActualField());
        out.writeOptionalString(this.fields.getPredictedField());
        out.writeOptionalString(this.fields.getTopClassesField());
        out.writeOptionalString(this.fields.getPredictedClassField());
        out.writeOptionalString(this.fields.getPredictedProbabilityField());
        out.writeNamedWriteableList(this.metrics);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(EvaluationFields.ACTUAL_FIELD.getPreferredName(), this.fields.getActualField());
        if (this.fields.getPredictedField() != null) {
            builder.field(EvaluationFields.PREDICTED_FIELD.getPreferredName(), this.fields.getPredictedField());
        }
        if (this.fields.getTopClassesField() != null) {
            builder.field(EvaluationFields.TOP_CLASSES_FIELD.getPreferredName(), this.fields.getTopClassesField());
        }
        builder.startObject(METRICS.getPreferredName());
        for (EvaluationMetric metric : this.metrics) {
            builder.field(metric.getName(), metric);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classification that = (Classification)o;
        return Objects.equals(that.fields, this.fields) && Objects.equals(that.metrics, this.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), EvaluationFields.ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), EvaluationFields.PREDICTED_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), EvaluationFields.TOP_CLASSES_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(EvaluationMetric.class, MlEvaluationNamedXContentProvider.registeredMetricName(NAME.getPreferredName(), n), c), METRICS);
    }
}

