/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.allocation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class AllocationStatus
implements Writeable,
ToXContentObject {
    public static ParseField ALLOCATION_COUNT = new ParseField("allocation_count", new String[0]);
    public static ParseField TARGET_ALLOCATION_COUNT = new ParseField("target_allocation_count", new String[0]);
    public static ParseField STATE = new ParseField("state", new String[0]);
    private static final ConstructingObjectParser<AllocationStatus, Void> PARSER = new ConstructingObjectParser("allocation_health", a -> new AllocationStatus((Integer)a[0], (Integer)a[1]));
    private final int allocationCount;
    private final int targetAllocationCount;

    public static AllocationStatus fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public AllocationStatus(int allocationCount, int targetAllocationCount) {
        this.allocationCount = allocationCount;
        this.targetAllocationCount = targetAllocationCount;
        if (allocationCount < 0) {
            throw new IllegalArgumentException("[" + ALLOCATION_COUNT.getPreferredName() + "] must be greater than or equal to 0");
        }
        if (targetAllocationCount < 0) {
            throw new IllegalArgumentException("[" + TARGET_ALLOCATION_COUNT.getPreferredName() + "] must be greater than or equal to 0");
        }
    }

    public AllocationStatus(StreamInput in) throws IOException {
        this.allocationCount = in.readVInt();
        this.targetAllocationCount = in.readVInt();
    }

    public State calculateState() {
        if (this.allocationCount == 0) {
            return State.STARTING;
        }
        if (this.allocationCount < this.targetAllocationCount) {
            return State.STARTED;
        }
        return State.FULLY_ALLOCATED;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ALLOCATION_COUNT.getPreferredName(), this.allocationCount);
        builder.field(TARGET_ALLOCATION_COUNT.getPreferredName(), this.targetAllocationCount);
        builder.field(STATE.getPreferredName(), this.calculateState());
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.allocationCount);
        out.writeVInt(this.targetAllocationCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllocationStatus that = (AllocationStatus)o;
        return this.allocationCount == that.allocationCount && this.targetAllocationCount == that.targetAllocationCount;
    }

    public int hashCode() {
        return Objects.hash(this.allocationCount, this.targetAllocationCount);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), ALLOCATION_COUNT);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), TARGET_ALLOCATION_COUNT);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), STATE);
    }

    public static enum State {
        STARTING,
        STARTED,
        FULLY_ALLOCATED;


        public static State fromString(String value) {
            return State.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public boolean isAnyOf(State ... candidates) {
            return Arrays.stream(candidates).anyMatch(candidate -> this == candidate);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

