/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.NlpInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.TopClassEntry;

public class NlpClassificationInferenceResults
extends NlpInferenceResults {
    public static final String NAME = "nlp_classification";
    protected final String resultsField;
    private final String classificationLabel;
    private final Double predictionProbability;
    private final List<TopClassEntry> topClasses;

    public NlpClassificationInferenceResults(String classificationLabel, List<TopClassEntry> topClasses, String resultsField, Double predictionProbability, boolean isTruncated) {
        super(isTruncated);
        this.classificationLabel = Objects.requireNonNull(classificationLabel);
        this.topClasses = topClasses == null ? Collections.emptyList() : Collections.unmodifiableList(topClasses);
        this.resultsField = resultsField;
        this.predictionProbability = predictionProbability;
    }

    public NlpClassificationInferenceResults(StreamInput in) throws IOException {
        super(in);
        this.classificationLabel = in.readString();
        this.topClasses = Collections.unmodifiableList(in.readList(TopClassEntry::new));
        this.resultsField = in.readString();
        this.predictionProbability = in.readOptionalDouble();
    }

    public String getClassificationLabel() {
        return this.classificationLabel;
    }

    public List<TopClassEntry> getTopClasses() {
        return this.topClasses;
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.classificationLabel);
        out.writeCollection(this.topClasses);
        out.writeString(this.resultsField);
        out.writeOptionalDouble(this.predictionProbability);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NlpClassificationInferenceResults that = (NlpClassificationInferenceResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.classificationLabel, that.classificationLabel) && Objects.equals(this.predictionProbability, that.predictionProbability) && Objects.equals(this.topClasses, that.topClasses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, this.classificationLabel, this.predictionProbability, this.topClasses);
    }

    public Double getPredictionProbability() {
        return this.predictionProbability;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public Object predictedValue() {
        return this.classificationLabel;
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.classificationLabel);
        if (!this.topClasses.isEmpty()) {
            map.put("top_classes", this.topClasses.stream().map(TopClassEntry::asValueMap).collect(Collectors.toList()));
        }
        if (this.predictionProbability != null) {
            map.put("prediction_probability", this.predictionProbability);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, this.classificationLabel);
        if (this.topClasses.size() > 0) {
            builder.field("top_classes", this.topClasses);
        }
        if (this.predictionProbability != null) {
            builder.field("prediction_probability", this.predictionProbability);
        }
    }
}

