/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;

public class InferenceStats
implements ToXContentObject,
Writeable {
    public static final String NAME = "inference_stats";
    public static final ParseField MISSING_ALL_FIELDS_COUNT = new ParseField("missing_all_fields_count", new String[0]);
    public static final ParseField INFERENCE_COUNT = new ParseField("inference_count", new String[0]);
    public static final ParseField CACHE_MISS_COUNT = new ParseField("cache_miss_count", new String[0]);
    public static final ParseField MODEL_ID = new ParseField("model_id", new String[0]);
    public static final ParseField NODE_ID = new ParseField("node_id", new String[0]);
    public static final ParseField FAILURE_COUNT = new ParseField("failure_count", new String[0]);
    public static final ParseField TYPE = new ParseField("type", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ConstructingObjectParser<InferenceStats, Void> PARSER = new ConstructingObjectParser("inference_stats", true, a -> new InferenceStats((Long)a[0], (Long)a[1], (Long)a[2], (Long)a[3], (String)a[4], (String)a[5], (Instant)a[6]));
    private final long missingAllFieldsCount;
    private final long inferenceCount;
    private final long failureCount;
    private final long cacheMissCount;
    private final String modelId;
    private final String nodeId;
    private final Instant timeStamp;

    public static String docId(String modelId, String nodeId) {
        return "inference_stats-" + modelId + "-" + nodeId;
    }

    private InferenceStats(Long missingAllFieldsCount, Long inferenceCount, Long failureCount, Long cacheMissCount, String modelId, String nodeId, Instant instant) {
        this(InferenceStats.unboxOrZero(missingAllFieldsCount), InferenceStats.unboxOrZero(inferenceCount), InferenceStats.unboxOrZero(failureCount), InferenceStats.unboxOrZero(cacheMissCount), modelId, nodeId, instant);
    }

    public InferenceStats(long missingAllFieldsCount, long inferenceCount, long failureCount, long cacheMissCount, String modelId, String nodeId, Instant timeStamp) {
        this.missingAllFieldsCount = missingAllFieldsCount;
        this.inferenceCount = inferenceCount;
        this.failureCount = failureCount;
        this.cacheMissCount = cacheMissCount;
        this.modelId = modelId;
        this.nodeId = nodeId;
        this.timeStamp = timeStamp == null ? Instant.ofEpochMilli(Instant.now().toEpochMilli()) : Instant.ofEpochMilli(timeStamp.toEpochMilli());
    }

    public InferenceStats(StreamInput in) throws IOException {
        this.missingAllFieldsCount = in.readVLong();
        this.inferenceCount = in.readVLong();
        this.failureCount = in.readVLong();
        this.cacheMissCount = in.readVLong();
        this.modelId = in.readOptionalString();
        this.nodeId = in.readOptionalString();
        this.timeStamp = in.readInstant();
    }

    public long getMissingAllFieldsCount() {
        return this.missingAllFieldsCount;
    }

    public long getInferenceCount() {
        return this.inferenceCount;
    }

    public long getFailureCount() {
        return this.failureCount;
    }

    public long getCacheMissCount() {
        return this.cacheMissCount;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    public boolean hasStats() {
        return this.missingAllFieldsCount > 0L || this.inferenceCount > 0L || this.failureCount > 0L || this.cacheMissCount > 0L;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            assert (this.modelId != null) : "model_id cannot be null when storing inference stats";
            assert (this.nodeId != null) : "node_id cannot be null when storing inference stats";
            builder.field(TYPE.getPreferredName(), NAME);
            builder.field(MODEL_ID.getPreferredName(), this.modelId);
            builder.field(NODE_ID.getPreferredName(), this.nodeId);
        }
        builder.field(FAILURE_COUNT.getPreferredName(), this.failureCount);
        builder.field(INFERENCE_COUNT.getPreferredName(), this.inferenceCount);
        builder.field(CACHE_MISS_COUNT.getPreferredName(), this.cacheMissCount);
        builder.field(MISSING_ALL_FIELDS_COUNT.getPreferredName(), this.missingAllFieldsCount);
        builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timeStamp.toEpochMilli());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceStats that = (InferenceStats)o;
        return this.missingAllFieldsCount == that.missingAllFieldsCount && this.inferenceCount == that.inferenceCount && this.failureCount == that.failureCount && this.cacheMissCount == that.cacheMissCount && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.timeStamp, that.timeStamp);
    }

    public int hashCode() {
        return Objects.hash(this.missingAllFieldsCount, this.inferenceCount, this.failureCount, this.cacheMissCount, this.modelId, this.nodeId, this.timeStamp);
    }

    public String toString() {
        return "InferenceStats{missingAllFieldsCount=" + this.missingAllFieldsCount + ", inferenceCount=" + this.inferenceCount + ", failureCount=" + this.failureCount + ", cacheMissCount=" + this.cacheMissCount + ", modelId='" + this.modelId + "', nodeId='" + this.nodeId + "', timeStamp=" + this.timeStamp + "}";
    }

    private static long unboxOrZero(@Nullable Long value) {
        return value == null ? 0L : value;
    }

    public static Accumulator accumulator(InferenceStats stats) {
        return new Accumulator(stats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.missingAllFieldsCount);
        out.writeVLong(this.inferenceCount);
        out.writeVLong(this.failureCount);
        out.writeVLong(this.cacheMissCount);
        out.writeOptionalString(this.modelId);
        out.writeOptionalString(this.nodeId);
        out.writeInstant(this.timeStamp);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MISSING_ALL_FIELDS_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INFERENCE_COUNT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), FAILURE_COUNT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CACHE_MISS_COUNT);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), MODEL_ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NODE_ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
    }

    public static class Accumulator {
        private long missingFieldsAccumulator = 0L;
        private long inferenceAccumulator = 0L;
        private long failureCountAccumulator = 0L;
        private long cacheMissAccumulator = 0L;
        private final String modelId;
        private final String nodeId;

        public Accumulator(String modelId, String nodeId, long cacheMisses) {
            this.modelId = modelId;
            this.nodeId = nodeId;
            this.cacheMissAccumulator = cacheMisses;
        }

        Accumulator(InferenceStats previousStats) {
            this.modelId = previousStats.modelId;
            this.nodeId = previousStats.nodeId;
            this.missingFieldsAccumulator += previousStats.missingAllFieldsCount;
            this.inferenceAccumulator += previousStats.inferenceCount;
            this.failureCountAccumulator += previousStats.failureCount;
            this.cacheMissAccumulator += previousStats.cacheMissCount;
        }

        public Accumulator merge(InferenceStats otherStats) {
            this.missingFieldsAccumulator += otherStats.missingAllFieldsCount;
            this.inferenceAccumulator += otherStats.inferenceCount;
            this.failureCountAccumulator += otherStats.failureCount;
            this.cacheMissAccumulator += otherStats.cacheMissCount;
            return this;
        }

        public synchronized Accumulator incMissingFields() {
            ++this.missingFieldsAccumulator;
            return this;
        }

        public synchronized Accumulator incInference() {
            ++this.inferenceAccumulator;
            return this;
        }

        public synchronized Accumulator incFailure() {
            ++this.failureCountAccumulator;
            return this;
        }

        public synchronized InferenceStats currentStatsAndReset() {
            InferenceStats stats = this.currentStats(Instant.now());
            this.missingFieldsAccumulator = 0L;
            this.inferenceAccumulator = 0L;
            this.failureCountAccumulator = 0L;
            this.cacheMissAccumulator = 0L;
            return stats;
        }

        public InferenceStats currentStats(Instant timeStamp) {
            return new InferenceStats(this.missingFieldsAccumulator, this.inferenceAccumulator, this.failureCountAccumulator, this.cacheMissAccumulator, this.modelId, this.nodeId, timeStamp);
        }
    }
}

