/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class NerConfig
implements NlpConfig {
    public static final String NAME = "ner";
    private static final ConstructingObjectParser<NerConfig, Void> STRICT_PARSER = NerConfig.createParser(false);
    private static final ConstructingObjectParser<NerConfig, Void> LENIENT_PARSER = NerConfig.createParser(true);
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final List<String> classificationLabels;
    private final String resultsField;

    public static NerConfig fromXContentStrict(XContentParser parser) {
        return STRICT_PARSER.apply(parser, null);
    }

    public static NerConfig fromXContentLenient(XContentParser parser) {
        return LENIENT_PARSER.apply(parser, null);
    }

    private static ConstructingObjectParser<NerConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<NerConfig, Void> parser = new ConstructingObjectParser<NerConfig, Void>(NAME, ignoreUnknownFields, a -> new NerConfig((VocabularyConfig)a[0], (Tokenization)a[1], (List)a[2], (String)a[3]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> p.namedObject(Tokenization.class, n, ignoreUnknownFields), TOKENIZATION);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), CLASSIFICATION_LABELS);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        return parser;
    }

    public NerConfig(@Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, @Nullable List<String> classificationLabels, @Nullable String resultsField) {
        this.vocabularyConfig = Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore()));
        this.tokenization = tokenization == null ? Tokenization.createDefault() : tokenization;
        this.classificationLabels = classificationLabels == null ? Collections.emptyList() : classificationLabels;
        this.resultsField = resultsField;
    }

    public NerConfig(StreamInput in) throws IOException {
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = in.readNamedWriteable(Tokenization.class);
        this.classificationLabels = in.readStringList();
        this.resultsField = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable(this.tokenization);
        out.writeStringCollection(this.classificationLabels);
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        if (!this.classificationLabels.isEmpty()) {
            builder.field(CLASSIFICATION_LABELS.getPreferredName(), this.classificationLabels);
        }
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.V_8_0_0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NerConfig that = (NerConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.classificationLabels, that.classificationLabels) && Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.vocabularyConfig, this.tokenization, this.classificationLabels, this.resultsField);
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    public List<String> getClassificationLabels() {
        return this.classificationLabels;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }
}

