/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public class FeatureImportanceBaseline
implements ToXContentObject,
Writeable {
    private static final String NAME = "feature_importance_baseline";
    public static final ParseField BASELINE = new ParseField("baseline", new String[0]);
    public static final ParseField CLASSES = new ParseField("classes", new String[0]);
    public static final ConstructingObjectParser<FeatureImportanceBaseline, Void> LENIENT_PARSER = FeatureImportanceBaseline.createParser(true);
    public static final ConstructingObjectParser<FeatureImportanceBaseline, Void> STRICT_PARSER = FeatureImportanceBaseline.createParser(false);
    public final Double baseline;
    public final List<ClassBaseline> classBaselines;

    private static ConstructingObjectParser<FeatureImportanceBaseline, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<FeatureImportanceBaseline, Void> parser = new ConstructingObjectParser<FeatureImportanceBaseline, Void>(NAME, ignoreUnknownFields, a -> new FeatureImportanceBaseline((Double)a[0], (List)a[1]));
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), BASELINE);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), ignoreUnknownFields ? ClassBaseline.LENIENT_PARSER : ClassBaseline.STRICT_PARSER, CLASSES);
        return parser;
    }

    public static FeatureImportanceBaseline fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? LENIENT_PARSER.parse(parser, null) : STRICT_PARSER.parse(parser, null);
    }

    public FeatureImportanceBaseline(StreamInput in) throws IOException {
        this.baseline = in.readOptionalDouble();
        this.classBaselines = in.readList(ClassBaseline::new);
    }

    public FeatureImportanceBaseline(Double baseline, List<ClassBaseline> classBaselines) {
        this.baseline = baseline;
        this.classBaselines = classBaselines == null ? Collections.emptyList() : classBaselines;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalDouble(this.baseline);
        out.writeList(this.classBaselines);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.asMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureImportanceBaseline that = (FeatureImportanceBaseline)o;
        return Objects.equals(that.baseline, this.baseline) && Objects.equals(this.classBaselines, that.classBaselines);
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.baseline != null) {
            map.put(BASELINE.getPreferredName(), this.baseline);
        }
        if (!this.classBaselines.isEmpty()) {
            map.put(CLASSES.getPreferredName(), this.classBaselines.stream().map(rec$ -> ((ClassBaseline)rec$).asMap()).collect(Collectors.toList()));
        }
        return map;
    }

    public int hashCode() {
        return Objects.hash(this.baseline, this.classBaselines);
    }

    public static class ClassBaseline
    implements ToXContentObject,
    Writeable {
        private static final String NAME = "feature_importance_class_baseline";
        public static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
        public static final ConstructingObjectParser<ClassBaseline, Void> LENIENT_PARSER = ClassBaseline.createParser(true);
        public static final ConstructingObjectParser<ClassBaseline, Void> STRICT_PARSER = ClassBaseline.createParser(false);
        public final Object className;
        public final double baseline;

        private static ConstructingObjectParser<ClassBaseline, Void> createParser(boolean ignoreUnknownFields) {
            ConstructingObjectParser<ClassBaseline, Void> parser = new ConstructingObjectParser<ClassBaseline, Void>(NAME, ignoreUnknownFields, a -> new ClassBaseline(a[0], (Double)a[1]));
            parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return p.text();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.numberValue();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                    return Boolean.valueOf(p.booleanValue());
                }
                throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
            }, CLASS_NAME, ObjectParser.ValueType.VALUE);
            parser.declareDouble(ConstructingObjectParser.constructorArg(), BASELINE);
            return parser;
        }

        public static ClassBaseline fromXContent(XContentParser parser, boolean lenient) throws IOException {
            return lenient ? LENIENT_PARSER.parse(parser, null) : STRICT_PARSER.parse(parser, null);
        }

        public ClassBaseline(StreamInput in) throws IOException {
            this.className = in.readGenericValue();
            this.baseline = in.readDouble();
        }

        ClassBaseline(Object className, double baseline) {
            this.className = className;
            this.baseline = baseline;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.className);
            out.writeDouble(this.baseline);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.map(this.asMap());
        }

        private Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(CLASS_NAME.getPreferredName(), this.className);
            map.put(BASELINE.getPreferredName(), this.baseline);
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassBaseline that = (ClassBaseline)o;
            return Objects.equals(that.className, this.className) && Objects.equals(this.baseline, that.baseline);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.baseline);
        }
    }
}

