/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MonitoringBulkResponse
extends ActionResponse {
    private long tookInMillis;
    private Error error;
    private boolean ignored;

    public MonitoringBulkResponse(long tookInMillis, boolean ignored) {
        this.tookInMillis = tookInMillis;
        this.ignored = ignored;
    }

    public MonitoringBulkResponse(long tookInMillis, Error error) {
        this(tookInMillis, false);
        this.error = error;
    }

    public MonitoringBulkResponse(StreamInput in) throws IOException {
        super(in);
        this.tookInMillis = in.readVLong();
        this.error = in.readOptionalWriteable(Error::new);
        this.ignored = in.readBoolean();
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public RestStatus status() {
        if (this.error == null) {
            return RestStatus.OK;
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public Error getError() {
        return this.error;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.tookInMillis);
        out.writeOptionalWriteable(this.error);
        out.writeBoolean(this.ignored);
    }

    public static class Error
    implements Writeable,
    ToXContentObject {
        private final Throwable cause;
        private final RestStatus status;

        public Error(Throwable t) {
            this.cause = Objects.requireNonNull(t);
            this.status = ExceptionsHelper.status(t);
        }

        public Error(StreamInput in) throws IOException {
            this((Throwable)in.readException());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeException(this.getCause());
        }

        public String getMessage() {
            return this.cause.toString();
        }

        public RestStatus getStatus() {
            return this.status;
        }

        public Throwable getCause() {
            return this.cause;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, this.cause);
            builder.endObject();
            return builder;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Error [");
            sb.append("cause=").append(this.cause);
            sb.append(", status=").append((Object)this.status);
            sb.append(']');
            return sb.toString();
        }
    }
}

