/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class MetricConfig
implements Writeable,
ToXContentObject {
    public static final ParseField MIN = new ParseField("min", new String[0]);
    public static final ParseField MAX = new ParseField("max", new String[0]);
    public static final ParseField SUM = new ParseField("sum", new String[0]);
    public static final ParseField AVG = new ParseField("avg", new String[0]);
    public static final ParseField VALUE_COUNT = new ParseField("value_count", new String[0]);
    public static final String NAME = "metrics";
    private static final String FIELD = "field";
    private static final String METRICS = "metrics";
    private static final ConstructingObjectParser<MetricConfig, Void> PARSER = new ConstructingObjectParser("metrics", args -> {
        List metrics = (List)args[1];
        return new MetricConfig((String)args[0], metrics);
    });
    private final String field;
    private final List<String> metrics;

    public MetricConfig(String field, List<String> metrics) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("Field must be a non-null, non-empty string");
        }
        if (metrics == null || metrics.isEmpty()) {
            throw new IllegalArgumentException("Metrics must be a non-null, non-empty array of strings");
        }
        metrics.forEach(m -> {
            if (!RollupField.SUPPORTED_METRICS.contains(m)) {
                throw new IllegalArgumentException("Unsupported metric [" + m + "]. Supported metrics include: " + RollupField.SUPPORTED_METRICS);
            }
        });
        this.field = field;
        this.metrics = metrics;
    }

    public MetricConfig(StreamInput in) throws IOException {
        this.field = in.readString();
        this.metrics = in.readStringList();
    }

    public String getField() {
        return this.field;
    }

    public List<String> getMetrics() {
        return this.metrics;
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Map<String, FieldCapabilities> fieldCaps = fieldCapsResponse.get(this.field);
        if (fieldCaps != null && !fieldCaps.isEmpty()) {
            fieldCaps.forEach((key, value) -> {
                if (!value.isAggregatable()) {
                    validationException.addValidationError("The field [" + this.field + "] must be aggregatable across all indices, but is not.");
                }
                if (!RollupField.NUMERIC_FIELD_MAPPER_TYPES.contains(key)) {
                    if (RollupField.DATE_FIELD_MAPPER_TYPES.contains(key)) {
                        if (!RollupField.SUPPORTED_DATE_METRICS.containsAll(this.metrics)) {
                            validationException.addValidationError(this.buildSupportedMetricError((String)key, RollupField.SUPPORTED_DATE_METRICS));
                        }
                    } else {
                        validationException.addValidationError("The field referenced by a metric group must be a [numeric] or [" + Strings.collectionToCommaDelimitedString(RollupField.DATE_FIELD_MAPPER_TYPES) + "] type, but found " + fieldCaps.keySet().toString() + " for field [" + this.field + "]");
                    }
                }
            });
        } else {
            validationException.addValidationError("Could not find a [numeric] or [" + Strings.collectionToCommaDelimitedString(RollupField.DATE_FIELD_MAPPER_TYPES) + "] field with name [" + this.field + "] in any of the indices matching the index pattern.");
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD, this.field);
        builder.stringListField("metrics", this.metrics);
        return builder.endObject();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeStringCollection(this.metrics);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MetricConfig that = (MetricConfig)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.metrics);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static MetricConfig fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private String buildSupportedMetricError(String type, List<String> supportedMetrics) {
        ArrayList<String> unsupportedMetrics = new ArrayList<String>(this.metrics);
        unsupportedMetrics.removeAll(supportedMetrics);
        return "Only the metrics " + supportedMetrics + " are supported for [" + type + "] types, but unsupported metrics " + unsupportedMetrics + " supplied for field [" + this.field + "]";
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("metrics", new String[0]));
    }
}

