/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.privilege;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class ClearPrivilegesCacheRequest
extends BaseNodesRequest<ClearPrivilegesCacheRequest> {
    private String[] applicationNames;
    private boolean clearRolesCache = false;

    public ClearPrivilegesCacheRequest() {
        super((String[])null);
    }

    public ClearPrivilegesCacheRequest(StreamInput in) throws IOException {
        super(in);
        this.applicationNames = in.readOptionalStringArray();
        this.clearRolesCache = in.readBoolean();
    }

    public ClearPrivilegesCacheRequest applicationNames(String ... applicationNames) {
        this.applicationNames = applicationNames;
        return this;
    }

    public ClearPrivilegesCacheRequest clearRolesCache(boolean clearRolesCache) {
        this.clearRolesCache = clearRolesCache;
        return this;
    }

    public String[] applicationNames() {
        return this.applicationNames;
    }

    public boolean clearRolesCache() {
        return this.clearRolesCache;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStringArray(this.applicationNames);
        out.writeBoolean(this.clearRolesCache);
    }

    public static class Node
    extends TransportRequest {
        private String[] applicationNames;
        private boolean clearRolesCache;

        public Node(StreamInput in) throws IOException {
            super(in);
            this.applicationNames = in.readOptionalStringArray();
            this.clearRolesCache = in.readBoolean();
        }

        public Node(ClearPrivilegesCacheRequest request) {
            this.applicationNames = request.applicationNames();
            this.clearRolesCache = request.clearRolesCache;
        }

        public String[] getApplicationNames() {
            return this.applicationNames;
        }

        public boolean clearRolesCache() {
            return this.clearRolesCache;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.applicationNames);
            out.writeBoolean(this.clearRolesCache);
        }
    }
}

