/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpgradeJobModelSnapshotAction
extends ActionType<Response> {
    public static final UpgradeJobModelSnapshotAction INSTANCE = new UpgradeJobModelSnapshotAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/model_snapshots/upgrade";

    private UpgradeJobModelSnapshotAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField NODE = new ParseField("node", new String[0]);
        public static final ParseField COMPLETED = new ParseField("completed", new String[0]);
        private static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser("cluster:admin/xpack/ml/job/model_snapshots/upgrade", a -> new Response((Boolean)a[0], (String)a[1]));
        private final boolean completed;
        private final String node;

        public static Response parseRequest(XContentParser parser) {
            return (Response)((Object)PARSER.apply(parser, null));
        }

        public Response(boolean completed, String node) {
            this.completed = completed;
            this.node = node;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.completed = in.readBoolean();
            this.node = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.completed);
            out.writeOptionalString(this.node);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(COMPLETED.getPreferredName(), this.completed);
            if (this.node != null) {
                builder.field(NODE.getPreferredName(), this.node);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.completed == response.completed && Objects.equals(this.node, response.node);
        }

        public int hashCode() {
            return Objects.hash(this.completed, this.node);
        }

        static {
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), COMPLETED);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), NODE);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        public static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueMinutes((long)30L);
        public static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField WAIT_FOR_COMPLETION = new ParseField("wait_for_completion", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("cluster:admin/xpack/ml/job/model_snapshots/upgrade", a -> new Request((String)a[0], (String)a[1], (String)a[2], (Boolean)a[3]));
        private final String jobId;
        private final String snapshotId;
        private final TimeValue timeout;
        private final boolean waitForCompletion;

        public static Request parseRequest(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        Request(String jobId, String snapshotId, String timeout, Boolean waitForCompletion) {
            this(jobId, snapshotId, timeout == null ? null : TimeValue.parseTimeValue((String)timeout, (String)TIMEOUT.getPreferredName()), waitForCompletion != null && waitForCompletion != false);
        }

        public Request(String jobId, String snapshotId, TimeValue timeValue, boolean waitForCompletion) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID);
            this.snapshotId = ExceptionsHelper.requireNonNull(snapshotId, SNAPSHOT_ID);
            this.timeout = timeValue == null ? DEFAULT_TIMEOUT : timeValue;
            this.waitForCompletion = waitForCompletion;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.snapshotId = in.readString();
            this.timeout = in.readTimeValue();
            this.waitForCompletion = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.snapshotId);
            out.writeTimeValue(this.timeout);
            out.writeBoolean(this.waitForCompletion);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public boolean isWaitForCompletion() {
            return this.waitForCompletion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.jobId, request.jobId) && Objects.equals(this.timeout, request.timeout) && Objects.equals(this.snapshotId, request.snapshotId) && this.waitForCompletion == request.waitForCompletion;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.snapshotId, this.timeout, this.waitForCompletion);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(SNAPSHOT_ID.getPreferredName(), this.snapshotId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.field(WAIT_FOR_COMPLETION.getPreferredName(), this.waitForCompletion);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), SNAPSHOT_ID);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TIMEOUT);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), WAIT_FOR_COMPLETION);
        }
    }
}

