/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.regression;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.Fields;
import org.elasticsearch.xpack.core.ml.dataframe.stats.regression.Hyperparameters;
import org.elasticsearch.xpack.core.ml.dataframe.stats.regression.TimingStats;
import org.elasticsearch.xpack.core.ml.dataframe.stats.regression.ValidationLoss;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class RegressionStats
implements AnalysisStats {
    public static final String TYPE_VALUE = "regression_stats";
    public static final ParseField ITERATION = new ParseField("iteration", new String[0]);
    public static final ParseField HYPERPARAMETERS = new ParseField("hyperparameters", new String[0]);
    public static final ParseField TIMING_STATS = new ParseField("timing_stats", new String[0]);
    public static final ParseField VALIDATION_LOSS = new ParseField("validation_loss", new String[0]);
    public static final ConstructingObjectParser<RegressionStats, Void> STRICT_PARSER = RegressionStats.createParser(false);
    public static final ConstructingObjectParser<RegressionStats, Void> LENIENT_PARSER = RegressionStats.createParser(true);
    private final String jobId;
    private final Instant timestamp;
    private final int iteration;
    private final Hyperparameters hyperparameters;
    private final TimingStats timingStats;
    private final ValidationLoss validationLoss;

    private static ConstructingObjectParser<RegressionStats, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(TYPE_VALUE, ignoreUnknownFields, a -> new RegressionStats((String)a[0], (Instant)a[1], (Integer)a[2], (Hyperparameters)a[3], (TimingStats)a[4], (ValidationLoss)a[5]));
        parser.declareString((bucket, s) -> {}, Fields.TYPE);
        parser.declareString(ConstructingObjectParser.constructorArg(), Fields.JOB_ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, Fields.TIMESTAMP.getPreferredName()), Fields.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareInt(ConstructingObjectParser.constructorArg(), ITERATION);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Hyperparameters.fromXContent(p, ignoreUnknownFields), HYPERPARAMETERS);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> TimingStats.fromXContent(p, ignoreUnknownFields), TIMING_STATS);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ValidationLoss.fromXContent(p, ignoreUnknownFields), VALIDATION_LOSS);
        return parser;
    }

    public RegressionStats(String jobId, Instant timestamp, int iteration, Hyperparameters hyperparameters, TimingStats timingStats, ValidationLoss validationLoss) {
        this.jobId = Objects.requireNonNull(jobId);
        this.timestamp = Instant.ofEpochMilli(ExceptionsHelper.requireNonNull(timestamp, Fields.TIMESTAMP).toEpochMilli());
        this.iteration = iteration;
        this.hyperparameters = Objects.requireNonNull(hyperparameters);
        this.timingStats = Objects.requireNonNull(timingStats);
        this.validationLoss = Objects.requireNonNull(validationLoss);
    }

    public RegressionStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.timestamp = in.readInstant();
        this.iteration = in.readVInt();
        this.hyperparameters = new Hyperparameters(in);
        this.timingStats = new TimingStats(in);
        this.validationLoss = new ValidationLoss(in);
    }

    public String getWriteableName() {
        return TYPE_VALUE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeInstant(this.timestamp);
        out.writeVInt(this.iteration);
        this.hyperparameters.writeTo(out);
        this.timingStats.writeTo(out);
        this.validationLoss.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(Fields.TYPE.getPreferredName(), TYPE_VALUE);
            builder.field(Fields.JOB_ID.getPreferredName(), this.jobId);
        }
        builder.timeField(Fields.TIMESTAMP.getPreferredName(), Fields.TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        builder.field(ITERATION.getPreferredName(), this.iteration);
        builder.field(HYPERPARAMETERS.getPreferredName(), (ToXContent)this.hyperparameters);
        builder.field(TIMING_STATS.getPreferredName(), (ToXContent)this.timingStats);
        builder.field(VALIDATION_LOSS.getPreferredName(), (ToXContent)this.validationLoss, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegressionStats that = (RegressionStats)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && this.iteration == that.iteration && Objects.equals(this.hyperparameters, that.hyperparameters) && Objects.equals(this.timingStats, that.timingStats) && Objects.equals(this.validationLoss, that.validationLoss);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.iteration, this.hyperparameters, this.timingStats, this.validationLoss);
    }

    public String documentId(String jobId) {
        return RegressionStats.documentIdPrefix(jobId) + this.timestamp.toEpochMilli();
    }

    public static String documentIdPrefix(String jobId) {
        return "regression_stats_" + jobId + "_";
    }
}

