/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.execution;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.watcher.actions.ActionWrapperResult;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.execution.ExecutionPhase;
import org.elasticsearch.xpack.core.watcher.execution.ExecutionState;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionResult;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionSnapshot;
import org.elasticsearch.xpack.core.watcher.execution.Wid;
import org.elasticsearch.xpack.core.watcher.history.WatchRecord;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.transform.Transform;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.core.watcher.watch.Watch;

public abstract class WatchExecutionContext {
    private final Wid id;
    private final ZonedDateTime executionTime;
    private final TriggerEvent triggerEvent;
    private final TimeValue defaultThrottlePeriod;
    private ExecutionPhase phase = ExecutionPhase.AWAITS_EXECUTION;
    private long relativeStartTime;
    private Watch watch;
    private Payload payload;
    private Map<String, Object> vars = new HashMap<String, Object>();
    private Input.Result inputResult;
    private Condition.Result conditionResult;
    private Transform.Result transformResult;
    private ConcurrentMap<String, ActionWrapperResult> actionsResults = ConcurrentCollections.newConcurrentMap();
    private String nodeId;
    private String user;

    public WatchExecutionContext(String watchId, ZonedDateTime executionTime, TriggerEvent triggerEvent, TimeValue defaultThrottlePeriod) {
        this.id = new Wid(watchId, executionTime);
        this.executionTime = executionTime;
        this.triggerEvent = triggerEvent;
        this.defaultThrottlePeriod = defaultThrottlePeriod;
    }

    public abstract boolean knownWatch();

    public abstract boolean simulateAction(String var1);

    public abstract boolean skipThrottling(String var1);

    public abstract boolean shouldBeExecuted();

    public abstract boolean recordExecution();

    public Watch watch() {
        return this.watch;
    }

    public final void ensureWatchExists(CheckedSupplier<Watch, Exception> supplier) throws Exception {
        if (this.watch == null) {
            this.watch = (Watch)supplier.get();
            this.user = WatchExecutionContext.getUsernameFromWatch(this.watch);
        }
    }

    public Wid id() {
        return this.id;
    }

    public ZonedDateTime executionTime() {
        return this.executionTime;
    }

    public TimeValue defaultThrottlePeriod() {
        return this.defaultThrottlePeriod;
    }

    public boolean overrideRecordOnConflict() {
        return false;
    }

    public TriggerEvent triggerEvent() {
        return this.triggerEvent;
    }

    public Payload payload() {
        return this.payload;
    }

    public Map<String, Object> vars() {
        return this.vars;
    }

    public ExecutionPhase executionPhase() {
        return this.phase;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getUser() {
        return this.user;
    }

    public void start() {
        assert (this.phase == ExecutionPhase.AWAITS_EXECUTION);
        this.relativeStartTime = System.nanoTime();
        this.phase = ExecutionPhase.STARTED;
    }

    public void beforeInput() {
        assert (this.phase == ExecutionPhase.STARTED);
        this.phase = ExecutionPhase.INPUT;
    }

    public void onInputResult(Input.Result inputResult) {
        assert (!this.phase.sealed());
        this.inputResult = inputResult;
        if (inputResult.status() == Input.Result.Status.SUCCESS) {
            this.payload = inputResult.payload();
        }
    }

    public Input.Result inputResult() {
        return this.inputResult;
    }

    public void beforeCondition() {
        assert (this.phase == ExecutionPhase.INPUT);
        this.phase = ExecutionPhase.CONDITION;
    }

    public void onConditionResult(Condition.Result conditionResult) {
        assert (!this.phase.sealed());
        this.conditionResult = conditionResult;
        this.watch().status().onCheck(conditionResult.met(), this.executionTime);
    }

    public Condition.Result conditionResult() {
        return this.conditionResult;
    }

    public void beforeWatchTransform() {
        assert (this.phase == ExecutionPhase.CONDITION);
        this.phase = ExecutionPhase.WATCH_TRANSFORM;
    }

    public void onWatchTransformResult(Transform.Result result) {
        assert (!this.phase.sealed());
        this.transformResult = result;
        if (result.status() == Transform.Result.Status.SUCCESS) {
            this.payload = result.payload();
        }
    }

    public Transform.Result transformResult() {
        return this.transformResult;
    }

    public void beforeActions() {
        assert (this.phase == ExecutionPhase.CONDITION || this.phase == ExecutionPhase.WATCH_TRANSFORM);
        this.phase = ExecutionPhase.ACTIONS;
    }

    public void onActionResult(ActionWrapperResult result) {
        assert (!this.phase.sealed());
        this.actionsResults.put(result.id(), result);
        this.watch().status().onActionResult(result.id(), this.executionTime, result.action());
    }

    public Map<String, ActionWrapperResult> actionsResults() {
        return Collections.unmodifiableMap(this.actionsResults);
    }

    public WatchRecord abortBeforeExecution(ExecutionState state, String message) {
        assert (!this.phase.sealed());
        this.phase = ExecutionPhase.ABORTED;
        return new WatchRecord.MessageWatchRecord(this.id, this.triggerEvent, state, message, this.getNodeId());
    }

    public WatchRecord abortFailedExecution(String message) {
        assert (!this.phase.sealed());
        this.phase = ExecutionPhase.ABORTED;
        long executionTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.relativeStartTime);
        WatchExecutionResult result = new WatchExecutionResult(this, executionTime);
        this.watch().status().setExecutionState(WatchRecord.getState(result));
        return new WatchRecord.MessageWatchRecord(this, result, message);
    }

    public WatchRecord abortFailedExecution(Exception e) {
        assert (!this.phase.sealed());
        this.phase = ExecutionPhase.ABORTED;
        long executionTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.relativeStartTime);
        WatchExecutionResult result = new WatchExecutionResult(this, executionTime);
        this.watch().status().setExecutionState(WatchRecord.getState(result));
        return new WatchRecord.ExceptionWatchRecord(this, result, e);
    }

    public WatchRecord finish() {
        assert (!this.phase.sealed());
        this.phase = ExecutionPhase.FINISHED;
        long executionTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.relativeStartTime);
        WatchExecutionResult result = new WatchExecutionResult(this, executionTime);
        this.watch().status().setExecutionState(WatchRecord.getState(result));
        return new WatchRecord.MessageWatchRecord(this, result);
    }

    public WatchExecutionSnapshot createSnapshot(Thread executionThread) {
        return new WatchExecutionSnapshot(this, executionThread.getStackTrace());
    }

    public static String getUsernameFromWatch(Watch watch) throws IOException {
        if (watch != null && watch.status() != null && watch.status().getHeaders() != null) {
            ClientHelper.assertNoAuthorizationHeader(watch.status().getHeaders());
            String header = watch.status().getHeaders().get("_xpack_security_authentication");
            if (header != null) {
                Authentication auth = AuthenticationContextSerializer.decode(header);
                return auth.getUser().principal();
            }
        }
        return null;
    }
}

