/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;

final class TransformPrivilegeChecker {
    static void checkPrivileges(String operationName, SecurityContext securityContext, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, Client client, TransformConfig config, boolean checkDestIndexPrivileges, ActionListener<Void> listener) {
        String username = securityContext.getUser().principal();
        ActionListener hasPrivilegesResponseListener = ActionListener.wrap(response -> TransformPrivilegeChecker.handlePrivilegesResponse(operationName, username, config.getId(), response, listener), arg_0 -> listener.onFailure(arg_0));
        HasPrivilegesRequest hasPrivilegesRequest = TransformPrivilegeChecker.buildPrivilegesRequest(config, indexNameExpressionResolver, clusterState, username, checkDestIndexPrivileges);
        client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)hasPrivilegesRequest, hasPrivilegesResponseListener);
    }

    private static HasPrivilegesRequest buildPrivilegesRequest(TransformConfig config, IndexNameExpressionResolver indexNameExpressionResolver, ClusterState clusterState, String username, boolean checkDestIndexPrivileges) {
        ArrayList<RoleDescriptor.IndicesPrivileges> indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>(2);
        RoleDescriptor.IndicesPrivileges sourceIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(config.getSource().getIndex()).privileges(new String[]{"read", "view_index_metadata"}).build();
        indicesPrivileges.add(sourceIndexPrivileges);
        if (checkDestIndexPrivileges) {
            String destIndex = config.getDestination().getIndex();
            String[] concreteDest = indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), new String[]{destIndex});
            ArrayList<String> destPrivileges = new ArrayList<String>(3);
            destPrivileges.add("read");
            destPrivileges.add("index");
            if (concreteDest.length == 0) {
                destPrivileges.add("create_index");
            }
            RoleDescriptor.IndicesPrivileges destIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{destIndex}).privileges(destPrivileges).build();
            indicesPrivileges.add(destIndexPrivileges);
        }
        HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
        privRequest.username(username);
        privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
        privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
        privRequest.indexPrivileges((RoleDescriptor.IndicesPrivileges[])indicesPrivileges.toArray(RoleDescriptor.IndicesPrivileges[]::new));
        return privRequest;
    }

    private static void handlePrivilegesResponse(String operationName, String username, String transformId, HasPrivilegesResponse privilegesResponse, ActionListener<Void> listener) {
        if (privilegesResponse.isCompleteMatch()) {
            listener.onResponse(null);
        } else {
            List indices = privilegesResponse.getIndexPrivileges().stream().map(ResourcePrivileges::getResource).collect(Collectors.toList());
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot {} transform [{}] because user {} lacks all the required permissions for indices: {}", (Object[])new Object[]{operationName, transformId, username, indices}));
        }
    }

    private TransformPrivilegeChecker() {
    }
}

