/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.checkpoint;

import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointException;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.transform.checkpoint.RemoteClusterResolver;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;

class DefaultCheckpointProvider
implements CheckpointProvider {
    private static final int AUDIT_CONCRETED_SOURCE_INDEX_CHANGES = 10;
    private static final Logger logger = LogManager.getLogger(DefaultCheckpointProvider.class);
    protected final Clock clock;
    protected final Client client;
    protected final RemoteClusterResolver remoteClusterResolver;
    protected final TransformConfigManager transformConfigManager;
    protected final TransformAuditor transformAuditor;
    protected final TransformConfig transformConfig;

    DefaultCheckpointProvider(Clock clock, Client client, RemoteClusterResolver remoteClusterResolver, TransformConfigManager transformConfigManager, TransformAuditor transformAuditor, TransformConfig transformConfig) {
        this.clock = clock;
        this.client = client;
        this.remoteClusterResolver = remoteClusterResolver;
        this.transformConfigManager = transformConfigManager;
        this.transformAuditor = transformAuditor;
        this.transformConfig = transformConfig;
    }

    @Override
    public void sourceHasChanged(TransformCheckpoint lastCheckpoint, ActionListener<Boolean> listener) {
        listener.onResponse((Object)false);
    }

    @Override
    public void createNextCheckpoint(TransformCheckpoint lastCheckpoint, ActionListener<TransformCheckpoint> listener) {
        long timestamp = this.clock.millis();
        long checkpoint = TransformCheckpoint.isNullOrEmpty((TransformCheckpoint)lastCheckpoint) ? 1L : lastCheckpoint.getCheckpoint() + 1L;
        this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)ActionListener.wrap(checkpointsByIndex -> {
            this.reportSourceIndexChanges(TransformCheckpoint.isNullOrEmpty((TransformCheckpoint)lastCheckpoint) ? Collections.emptySet() : lastCheckpoint.getIndicesCheckpoints().keySet(), checkpointsByIndex.keySet());
            listener.onResponse((Object)new TransformCheckpoint(this.transformConfig.getId(), timestamp, checkpoint, checkpointsByIndex, Long.valueOf(0L)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected void getIndexCheckpoints(ActionListener<Map<String, long[]>> listener) {
        try {
            RemoteClusterResolver.ResolvedIndices resolvedIndexes = this.remoteClusterResolver.resolve(this.transformConfig.getSource().getIndex());
            GroupedActionListener groupedListener = listener;
            if (resolvedIndexes.numClusters() > 1) {
                ActionListener mergeMapsListener = ActionListener.wrap(indexCheckpoints -> listener.onResponse(indexCheckpoints.stream().flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (long[])entry.getValue()))), arg_0 -> listener.onFailure(arg_0));
                groupedListener = new GroupedActionListener(mergeMapsListener, resolvedIndexes.numClusters());
            }
            if (!resolvedIndexes.getLocalIndices().isEmpty()) {
                DefaultCheckpointProvider.getCheckpointsFromOneCluster(this.client, this.transformConfig.getHeaders(), resolvedIndexes.getLocalIndices().toArray(new String[0]), "", (ActionListener<Map<String, long[]>>)groupedListener);
            }
            for (Map.Entry<String, List<String>> remoteIndex : resolvedIndexes.getRemoteIndicesPerClusterAlias().entrySet()) {
                Client remoteClient = this.client.getRemoteClusterClient(remoteIndex.getKey());
                DefaultCheckpointProvider.getCheckpointsFromOneCluster(remoteClient, this.transformConfig.getHeaders(), remoteIndex.getValue().toArray(new String[0]), remoteIndex.getKey() + ":", (ActionListener<Map<String, long[]>>)groupedListener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static void getCheckpointsFromOneCluster(Client client, Map<String, String> headers, String[] indices, String prefix, ActionListener<Map<String, long[]>> listener) {
        GetIndexRequest getIndexRequest = (GetIndexRequest)((GetIndexRequest)new GetIndexRequest().indices(indices)).features(new GetIndexRequest.Feature[0]).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        ClientHelper.executeWithHeadersAsync(headers, (String)"transform", (Client)client, (ActionType)GetIndexAction.INSTANCE, (ActionRequest)getIndexRequest, (ActionListener)ActionListener.wrap(getIndexResponse -> {
            HashSet<String> userIndices = getIndexResponse.getIndices() != null ? new HashSet<String>(Arrays.asList(getIndexResponse.getIndices())) : Collections.emptySet();
            ClientHelper.executeAsyncWithOrigin((Client)client, (String)"transform", (ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(indices)).clear().indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN)), (ActionListener)ActionListener.wrap(response -> {
                if (response.getFailedShards() != 0) {
                    for (int i = 0; i < response.getShardFailures().length; ++i) {
                        logger.warn(new ParameterizedMessage("Source has [{}] failed shards, shard failure [{}]", (Object)response.getFailedShards(), (Object)i).getFormattedMessage(), (Throwable)response.getShardFailures()[i]);
                    }
                    listener.onFailure((Exception)((Object)new CheckpointException("Source has [{}] failed shards, first shard failure: {}", (Throwable)response.getShardFailures()[0], response.getFailedShards(), response.getShardFailures()[0].toString())));
                    return;
                }
                listener.onResponse(DefaultCheckpointProvider.extractIndexCheckPoints(response.getShards(), userIndices, prefix));
            }, e -> listener.onFailure((Exception)((Object)new CheckpointException("Failed to create checkpoint", (Throwable)e, new Object[0])))));
        }, e -> listener.onFailure((Exception)((Object)new CheckpointException("Failed to create checkpoint", (Throwable)e, new Object[0])))));
    }

    static Map<String, long[]> extractIndexCheckPoints(ShardStats[] shards, Set<String> userIndices, String prefix) {
        TreeMap<Object, TreeMap> checkpointsByIndex = new TreeMap<Object, TreeMap>();
        for (ShardStats shard : shards) {
            String indexName2 = shard.getShardRouting().getIndexName();
            if (!userIndices.contains(indexName2)) continue;
            long globalCheckpoint = shard.getSeqNoStats() == null ? -1L : shard.getSeqNoStats().getGlobalCheckpoint();
            String fullIndexName = prefix + indexName2;
            if (checkpointsByIndex.containsKey(fullIndexName)) {
                TreeMap checkpoints2 = (TreeMap)checkpointsByIndex.get(fullIndexName);
                if (checkpoints2.containsKey(shard.getShardRouting().getId()) && (Long)checkpoints2.get(shard.getShardRouting().getId()) >= globalCheckpoint) continue;
                checkpoints2.put(shard.getShardRouting().getId(), globalCheckpoint);
                continue;
            }
            checkpointsByIndex.put(fullIndexName, new TreeMap());
            ((TreeMap)checkpointsByIndex.get(fullIndexName)).put(shard.getShardRouting().getId(), globalCheckpoint);
        }
        if (logger.isDebugEnabled()) {
            HashSet<String> userIndicesClone = new HashSet<String>(userIndices);
            userIndicesClone.removeAll(checkpointsByIndex.keySet());
            if (!userIndicesClone.isEmpty()) {
                logger.debug("Original set of user indices contained more indexes [{}]", userIndicesClone);
            }
        }
        TreeMap<String, long[]> checkpointsByIndexReduced = new TreeMap<String, long[]>();
        checkpointsByIndex.forEach((indexName, checkpoints) -> checkpointsByIndexReduced.put((String)indexName, checkpoints.values().stream().mapToLong(l -> l).toArray()));
        return checkpointsByIndexReduced;
    }

    @Override
    public void getCheckpointingInfo(TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint, TransformIndexerPosition nextCheckpointPosition, TransformProgress nextCheckpointProgress, ActionListener<TransformCheckpointingInfo.TransformCheckpointingInfoBuilder> listener) {
        TransformCheckpointingInfo.TransformCheckpointingInfoBuilder checkpointingInfoBuilder = new TransformCheckpointingInfo.TransformCheckpointingInfoBuilder();
        checkpointingInfoBuilder.setLastCheckpoint(lastCheckpoint).setNextCheckpoint(nextCheckpoint).setNextCheckpointPosition(nextCheckpointPosition).setNextCheckpointProgress(nextCheckpointProgress);
        long timestamp = this.clock.millis();
        this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)ActionListener.wrap(checkpointsByIndex -> {
            TransformCheckpoint sourceCheckpoint = new TransformCheckpoint(this.transformConfig.getId(), timestamp, -1L, checkpointsByIndex, Long.valueOf(0L));
            checkpointingInfoBuilder.setSourceCheckpoint(sourceCheckpoint);
            checkpointingInfoBuilder.setOperationsBehind(TransformCheckpoint.getBehind((TransformCheckpoint)lastCheckpoint, (TransformCheckpoint)sourceCheckpoint));
            listener.onResponse((Object)checkpointingInfoBuilder);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void getCheckpointingInfo(long lastCheckpointNumber, TransformIndexerPosition nextCheckpointPosition, TransformProgress nextCheckpointProgress, ActionListener<TransformCheckpointingInfo.TransformCheckpointingInfoBuilder> listener) {
        TransformCheckpointingInfo.TransformCheckpointingInfoBuilder checkpointingInfoBuilder = new TransformCheckpointingInfo.TransformCheckpointingInfoBuilder();
        checkpointingInfoBuilder.setNextCheckpointPosition(nextCheckpointPosition).setNextCheckpointProgress(nextCheckpointProgress);
        checkpointingInfoBuilder.setLastCheckpoint(TransformCheckpoint.EMPTY);
        long timestamp = this.clock.millis();
        ActionListener checkpointsByIndexListener = ActionListener.wrap(checkpointsByIndex -> {
            TransformCheckpoint sourceCheckpoint = new TransformCheckpoint(this.transformConfig.getId(), timestamp, -1L, checkpointsByIndex, Long.valueOf(0L));
            checkpointingInfoBuilder.setSourceCheckpoint(sourceCheckpoint);
            checkpointingInfoBuilder.setOperationsBehind(TransformCheckpoint.getBehind((TransformCheckpoint)checkpointingInfoBuilder.getLastCheckpoint(), (TransformCheckpoint)sourceCheckpoint));
            listener.onResponse((Object)checkpointingInfoBuilder);
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("[{}] failed to retrieve source checkpoint for transform", (Object)this.transformConfig.getId()), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during source checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        ActionListener nextCheckpointListener = ActionListener.wrap(nextCheckpointObj -> {
            checkpointingInfoBuilder.setNextCheckpoint(nextCheckpointObj);
            this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)checkpointsByIndexListener);
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("[{}] failed to retrieve next checkpoint [{}]", (Object)this.transformConfig.getId(), (Object)(lastCheckpointNumber + 1L)), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during next checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        ActionListener lastCheckpointListener = ActionListener.wrap(lastCheckpointObj -> {
            checkpointingInfoBuilder.setChangesLastDetectedAt(Instant.ofEpochMilli(lastCheckpointObj.getTimestamp()));
            checkpointingInfoBuilder.setLastCheckpoint(lastCheckpointObj);
            this.transformConfigManager.getTransformCheckpoint(this.transformConfig.getId(), lastCheckpointNumber + 1L, (ActionListener<TransformCheckpoint>)nextCheckpointListener);
        }, e -> {
            logger.debug(() -> new ParameterizedMessage("[{}] failed to retrieve last checkpoint [{}]", (Object)this.transformConfig.getId(), (Object)lastCheckpointNumber), (Throwable)e);
            listener.onFailure((Exception)((Object)new CheckpointException("Failure during last checkpoint info retrieval", (Throwable)e, new Object[0])));
        });
        if (lastCheckpointNumber != 0L) {
            this.transformConfigManager.getTransformCheckpoint(this.transformConfig.getId(), lastCheckpointNumber, (ActionListener<TransformCheckpoint>)lastCheckpointListener);
        } else {
            this.getIndexCheckpoints((ActionListener<Map<String, long[]>>)checkpointsByIndexListener);
        }
    }

    void reportSourceIndexChanges(Set<String> lastSourceIndexes, Set<String> newSourceIndexes) {
        if (newSourceIndexes.isEmpty() && !lastSourceIndexes.isEmpty()) {
            String message = "Source did not resolve to any open indexes";
            logger.warn("[{}] {}", (Object)this.transformConfig.getId(), (Object)message);
            this.transformAuditor.warning(this.transformConfig.getId(), message);
        } else {
            Set removedIndexes = Sets.difference(lastSourceIndexes, newSourceIndexes);
            Set addedIndexes = Sets.difference(newSourceIndexes, lastSourceIndexes);
            if (removedIndexes.size() + addedIndexes.size() > 10) {
                String message = "Source index resolve found more than 10 changes, [" + removedIndexes.size() + "] removed indexes, [" + addedIndexes.size() + "] new indexes";
                logger.debug("[{}] {}", (Object)this.transformConfig.getId(), (Object)message);
                this.transformAuditor.info(this.transformConfig.getId(), message);
            } else if (removedIndexes.size() + addedIndexes.size() > 0) {
                String message = "Source index resolve found changes, removedIndexes: " + removedIndexes + ", new indexes: " + addedIndexes;
                logger.debug("[{}] {}", (Object)this.transformConfig.getId(), (Object)message);
                this.transformAuditor.info(this.transformConfig.getId(), message);
            }
        }
    }
}

