/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.RecvByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.transport.netty4.Netty4NioSocketChannel;

@SuppressForbidden(reason="Channel#write")
public class CopyBytesSocketChannel
extends Netty4NioSocketChannel {
    private static final int MAX_BYTES_PER_WRITE = StrictMath.toIntExact(ByteSizeValue.parseBytesSizeValue((String)System.getProperty("es.transport.buffer.size", "1m"), (String)"es.transport.buffer.size").getBytes());
    private static final ThreadLocal<ByteBuffer> ioBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(MAX_BYTES_PER_WRITE));
    private final WriteConfig writeConfig = new WriteConfig();

    public CopyBytesSocketChannel() {
    }

    CopyBytesSocketChannel(Channel parent, SocketChannel socket) {
        super(parent, socket);
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        int writeSpinCount = this.config().getWriteSpinCount();
        do {
            if (in.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int maxBytesPerGatheringWrite = this.writeConfig.getMaxBytesPerGatheringWrite();
            ByteBuffer[] nioBuffers = in.nioBuffers(1024, (long)maxBytesPerGatheringWrite);
            int nioBufferCnt = in.nioBufferCount();
            if (nioBufferCnt == 0) {
                writeSpinCount -= this.doWrite0(in);
                continue;
            }
            ByteBuffer ioBuffer = CopyBytesSocketChannel.getIoBuffer();
            CopyBytesSocketChannel.copyBytes(nioBuffers, nioBufferCnt, ioBuffer);
            ioBuffer.flip();
            int attemptedBytes = ioBuffer.remaining();
            int localWrittenBytes = this.writeToSocketChannel(this.javaChannel(), ioBuffer);
            if (localWrittenBytes <= 0) {
                this.incompleteWrite(true);
                return;
            }
            this.adjustMaxBytesPerGatheringWrite(attemptedBytes, localWrittenBytes, maxBytesPerGatheringWrite);
            CopyBytesSocketChannel.setWrittenBytes(nioBuffers, localWrittenBytes);
            in.removeBytes((long)localWrittenBytes);
            --writeSpinCount;
        } while (writeSpinCount > 0);
        this.incompleteWrite(writeSpinCount < 0);
    }

    protected int doReadBytes(ByteBuf byteBuf) throws Exception {
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        int writeableBytes = Math.min(byteBuf.writableBytes(), MAX_BYTES_PER_WRITE);
        allocHandle.attemptedBytesRead(writeableBytes);
        ByteBuffer ioBuffer = CopyBytesSocketChannel.getIoBuffer().limit(writeableBytes);
        int bytesRead = this.readFromSocketChannel(this.javaChannel(), ioBuffer);
        ioBuffer.flip();
        if (bytesRead > 0) {
            byteBuf.writeBytes(ioBuffer);
        }
        return bytesRead;
    }

    protected int writeToSocketChannel(SocketChannel socketChannel, ByteBuffer ioBuffer) throws IOException {
        return socketChannel.write(ioBuffer);
    }

    protected int readFromSocketChannel(SocketChannel socketChannel, ByteBuffer ioBuffer) throws IOException {
        return socketChannel.read(ioBuffer);
    }

    private static ByteBuffer getIoBuffer() {
        ByteBuffer ioBuffer = CopyBytesSocketChannel.ioBuffer.get();
        ioBuffer.clear();
        return ioBuffer;
    }

    private void adjustMaxBytesPerGatheringWrite(int attempted, int written, int oldMaxBytesPerGatheringWrite) {
        if (attempted == written) {
            if (attempted << 1 > oldMaxBytesPerGatheringWrite) {
                this.writeConfig.setMaxBytesPerGatheringWrite(attempted << 1);
            }
        } else if (attempted > 4096 && written < attempted >>> 1) {
            this.writeConfig.setMaxBytesPerGatheringWrite(attempted >>> 1);
        }
    }

    private static void copyBytes(ByteBuffer[] source, int nioBufferCnt, ByteBuffer destination) {
        for (int i = 0; i < nioBufferCnt && destination.hasRemaining(); ++i) {
            ByteBuffer buffer = source[i];
            int nBytesToCopy = Math.min(destination.remaining(), buffer.remaining());
            if (buffer.hasArray()) {
                destination.put(buffer.array(), buffer.arrayOffset() + buffer.position(), nBytesToCopy);
                continue;
            }
            int initialLimit = buffer.limit();
            int initialPosition = buffer.position();
            buffer.limit(buffer.position() + nBytesToCopy);
            destination.put(buffer);
            buffer.position(initialPosition);
            buffer.limit(initialLimit);
        }
    }

    private static void setWrittenBytes(ByteBuffer[] source, int bytesWritten) {
        int i = 0;
        while (bytesWritten > 0) {
            ByteBuffer buffer = source[i];
            int nBytes = Math.min(buffer.remaining(), bytesWritten);
            buffer.position(buffer.position() + nBytes);
            bytesWritten -= nBytes;
            ++i;
        }
    }

    private final class WriteConfig {
        private volatile int maxBytesPerGatheringWrite = MAX_BYTES_PER_WRITE;

        private WriteConfig() {
            this.calculateMaxBytesPerGatheringWrite();
        }

        void setMaxBytesPerGatheringWrite(int maxBytesPerGatheringWrite) {
            this.maxBytesPerGatheringWrite = Math.min(maxBytesPerGatheringWrite, MAX_BYTES_PER_WRITE);
        }

        int getMaxBytesPerGatheringWrite() {
            return this.maxBytesPerGatheringWrite;
        }

        private void calculateMaxBytesPerGatheringWrite() {
            int newSendBufferSize = CopyBytesSocketChannel.this.config().getSendBufferSize() << 1;
            if (newSendBufferSize > 0) {
                this.setMaxBytesPerGatheringWrite(CopyBytesSocketChannel.this.config().getSendBufferSize() << 1);
            }
        }
    }
}

