/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

class VectorTileRequest {
    protected static final String INDEX_PARAM = "index";
    protected static final String FIELD_PARAM = "field";
    protected static final String Z_PARAM = "z";
    protected static final String X_PARAM = "x";
    protected static final String Y_PARAM = "y";
    protected static final ParseField GRID_PRECISION_FIELD = new ParseField("grid_precision", new String[0]);
    protected static final ParseField GRID_TYPE_FIELD = new ParseField("grid_type", new String[0]);
    protected static final ParseField EXTENT_FIELD = new ParseField("extent", new String[0]);
    protected static final ParseField EXACT_BOUNDS_FIELD = new ParseField("exact_bounds", new String[0]);
    private static final ObjectParser<VectorTileRequest, RestRequest> PARSER = new ObjectParser("vector-tile");
    private static final String SCRIPT = "ScriptDocValues.Geometry geometry = doc[params.field];double w = geometry.getMercatorWidth();double h = geometry.getMercatorHeight();return h * h + w * w;";
    private final String[] indexes;
    private final String field;
    private final int x;
    private final int y;
    private final int z;
    private final Rectangle bbox;
    private QueryBuilder queryBuilder = Defaults.QUERY;
    private Map<String, Object> runtimeMappings = Defaults.RUNTIME_MAPPINGS;
    private int gridPrecision = 8;
    private GRID_TYPE gridType = Defaults.GRID_TYPE;
    private int size = 10000;
    private int extent = 4096;
    private List<ValuesSourceAggregationBuilder.MetricsAggregationBuilder<?, ?>> aggs = Defaults.AGGS;
    private List<FieldAndFormat> fields = Defaults.FETCH;
    private List<SortBuilder<?>> sortBuilders;
    private boolean exact_bounds = false;
    private int trackTotalHitsUpTo = 10000;

    static VectorTileRequest parseRestRequest(RestRequest restRequest) throws IOException {
        VectorTileRequest request = new VectorTileRequest(Strings.splitStringByCommaToArray((String)restRequest.param(INDEX_PARAM)), restRequest.param(FIELD_PARAM), Integer.parseInt(restRequest.param(Z_PARAM)), Integer.parseInt(restRequest.param(X_PARAM)), Integer.parseInt(restRequest.param(Y_PARAM)));
        if (restRequest.hasContentOrSourceParam()) {
            try (XContentParser contentParser = restRequest.contentOrSourceParamParser();){
                PARSER.parse(contentParser, (Object)request, (Object)restRequest);
            }
        }
        if (restRequest.hasParam(SearchSourceBuilder.SIZE_FIELD.getPreferredName())) {
            request.setSize(restRequest.paramAsInt(SearchSourceBuilder.SIZE_FIELD.getPreferredName(), 10000));
        }
        if (restRequest.hasParam(GRID_PRECISION_FIELD.getPreferredName())) {
            request.setGridPrecision(restRequest.paramAsInt(GRID_PRECISION_FIELD.getPreferredName(), 8));
        }
        if (restRequest.hasParam(EXTENT_FIELD.getPreferredName())) {
            request.setExtent(restRequest.paramAsInt(EXTENT_FIELD.getPreferredName(), 4096));
        }
        if (restRequest.hasParam(GRID_TYPE_FIELD.getPreferredName())) {
            request.setGridType(restRequest.param(GRID_TYPE_FIELD.getPreferredName(), Defaults.GRID_TYPE.name()));
        }
        if (restRequest.hasParam(EXACT_BOUNDS_FIELD.getPreferredName())) {
            request.setExactBounds(restRequest.paramAsBoolean(EXACT_BOUNDS_FIELD.getPreferredName(), false));
        }
        if (restRequest.hasParam(SearchSourceBuilder.TRACK_TOTAL_HITS_FIELD.getPreferredName())) {
            if (Booleans.isBoolean((String)restRequest.param(SearchSourceBuilder.TRACK_TOTAL_HITS_FIELD.getPreferredName()))) {
                if (restRequest.paramAsBoolean(SearchSourceBuilder.TRACK_TOTAL_HITS_FIELD.getPreferredName(), true)) {
                    request.setTrackTotalHitsUpTo(Integer.MAX_VALUE);
                } else {
                    request.setTrackTotalHitsUpTo(-1);
                }
            } else {
                request.setTrackTotalHitsUpTo(restRequest.paramAsInt(SearchSourceBuilder.TRACK_TOTAL_HITS_FIELD.getPreferredName(), 10000));
            }
        }
        return request;
    }

    private VectorTileRequest(String[] indexes, String field, int z, int x, int y) {
        this.indexes = indexes;
        this.field = field;
        this.z = z;
        this.x = x;
        this.y = y;
        this.bbox = GeoTileUtils.toBoundingBox((int)x, (int)y, (int)z);
    }

    public String[] getIndexes() {
        return this.indexes;
    }

    public String getField() {
        return this.field;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    public int getExtent() {
        return this.extent;
    }

    private void setExtent(int extent) {
        if (extent < 0) {
            throw new IllegalArgumentException("[extent] parameter cannot be negative, found [" + extent + "]");
        }
        this.extent = extent;
    }

    public boolean getExactBounds() {
        return this.exact_bounds;
    }

    private void setExactBounds(boolean exact_bounds) {
        this.exact_bounds = exact_bounds;
    }

    public List<FieldAndFormat> getFieldAndFormats() {
        return this.fields;
    }

    private void setFieldAndFormats(List<FieldAndFormat> fields) {
        this.fields = fields;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    private void setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public Map<String, Object> getRuntimeMappings() {
        return this.runtimeMappings;
    }

    private void setRuntimeMappings(Map<String, Object> runtimeMappings) {
        this.runtimeMappings = runtimeMappings;
    }

    public int getGridPrecision() {
        return this.gridPrecision;
    }

    private void setGridPrecision(int gridPrecision) {
        if (gridPrecision < 0) {
            throw new IllegalArgumentException("[gridPrecision] parameter cannot be negative, found [" + gridPrecision + "]");
        }
        if (gridPrecision > 8) {
            throw new IllegalArgumentException("[gridPrecision] parameter cannot be bigger than 8, found [" + gridPrecision + "]");
        }
        this.gridPrecision = gridPrecision;
    }

    public GRID_TYPE getGridType() {
        return this.gridType;
    }

    private void setGridType(String gridType) {
        this.gridType = GRID_TYPE.fromString(gridType);
    }

    public int getSize() {
        return this.size;
    }

    private void setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("[size] parameter cannot be negative, found [" + size + "]");
        }
        this.size = size;
    }

    public List<ValuesSourceAggregationBuilder.MetricsAggregationBuilder<?, ?>> getAggBuilder() {
        return this.aggs;
    }

    private void setAggBuilder(AggregatorFactories.Builder aggBuilder) {
        ArrayList aggs = new ArrayList(aggBuilder.count());
        for (AggregationBuilder aggregation : aggBuilder.getAggregatorFactories()) {
            if (aggregation instanceof ValuesSourceAggregationBuilder.MetricsAggregationBuilder) {
                aggs.add((ValuesSourceAggregationBuilder.MetricsAggregationBuilder)aggregation);
                continue;
            }
            throw new IllegalArgumentException("Unsupported aggregation of type [" + aggregation.getType() + "].Only metric aggregations are supported.");
        }
        Iterator iterator = aggBuilder.getPipelineAggregatorFactories().iterator();
        if (iterator.hasNext()) {
            AggregationBuilder aggregation;
            aggregation = (PipelineAggregationBuilder)iterator.next();
            String type = aggregation.getType();
            throw new IllegalArgumentException("Unsupported pipeline aggregation of type [" + type + "]");
        }
        this.aggs = aggs;
    }

    public List<SortBuilder<?>> getSortBuilders() {
        if (this.sortBuilders == null) {
            if (this.size == 0) {
                return List.of();
            }
            return List.of(new ScriptSortBuilder(new Script(Script.DEFAULT_SCRIPT_TYPE, "painless", SCRIPT, Map.of(FIELD_PARAM, this.getField())), ScriptSortBuilder.ScriptSortType.NUMBER).order(SortOrder.DESC));
        }
        return this.sortBuilders;
    }

    private void setSortBuilders(List<SortBuilder<?>> sortBuilders) {
        this.sortBuilders = sortBuilders;
    }

    public int getTrackTotalHitsUpTo() {
        return this.trackTotalHitsUpTo;
    }

    private void setTrackTotalHitsUpTo(int trackTotalHitsUpTo) {
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
    }

    static {
        PARSER.declareInt(VectorTileRequest::setSize, SearchSourceBuilder.SIZE_FIELD);
        PARSER.declareField(VectorTileRequest::setFieldAndFormats, p -> {
            ArrayList<FieldAndFormat> fetchFields = new ArrayList<FieldAndFormat>();
            while (p.nextToken() != XContentParser.Token.END_ARRAY) {
                fetchFields.add(FieldAndFormat.fromXContent((XContentParser)p));
            }
            return fetchFields;
        }, SearchSourceBuilder.FETCH_FIELDS_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareField(VectorTileRequest::setQueryBuilder, AbstractQueryBuilder::parseInnerQueryBuilder, SearchSourceBuilder.QUERY_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(VectorTileRequest::setRuntimeMappings, XContentParser::map, SearchSourceBuilder.RUNTIME_MAPPINGS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(VectorTileRequest::setAggBuilder, AggregatorFactories::parseAggregators, SearchSourceBuilder.AGGS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(VectorTileRequest::setSortBuilders, SortBuilder::fromXContent, SearchSourceBuilder.SORT_FIELD, ObjectParser.ValueType.OBJECT_ARRAY);
        PARSER.declareInt(VectorTileRequest::setGridPrecision, GRID_PRECISION_FIELD);
        PARSER.declareString(VectorTileRequest::setGridType, GRID_TYPE_FIELD);
        PARSER.declareInt(VectorTileRequest::setExtent, EXTENT_FIELD);
        PARSER.declareBoolean(VectorTileRequest::setExactBounds, EXACT_BOUNDS_FIELD);
        PARSER.declareField(VectorTileRequest::setTrackTotalHitsUpTo, p -> {
            XContentParser.Token token = p.currentToken();
            if (token == XContentParser.Token.VALUE_BOOLEAN || token == XContentParser.Token.VALUE_STRING && Booleans.isBoolean((String)p.text())) {
                return p.booleanValue() ? Integer.MAX_VALUE : -1;
            }
            return p.intValue();
        }, SearchSourceBuilder.TRACK_TOTAL_HITS_FIELD, ObjectParser.ValueType.VALUE);
    }

    protected static class Defaults {
        public static final int SIZE = 10000;
        public static final List<FieldAndFormat> FETCH = Collections.emptyList();
        public static final Map<String, Object> RUNTIME_MAPPINGS = Collections.emptyMap();
        public static final QueryBuilder QUERY = null;
        public static final List<ValuesSourceAggregationBuilder.MetricsAggregationBuilder<?, ?>> AGGS = Collections.emptyList();
        public static final int GRID_PRECISION = 8;
        public static final GRID_TYPE GRID_TYPE = org.elasticsearch.xpack.vectortile.rest.VectorTileRequest$GRID_TYPE.GRID;
        public static final int EXTENT = 4096;
        public static final boolean EXACT_BOUNDS = false;
        public static final int TRACK_TOTAL_HITS_UP_TO = 10000;

        protected Defaults() {
        }
    }

    protected static enum GRID_TYPE {
        GRID,
        POINT,
        CENTROID;


        private static GRID_TYPE fromString(String type) {
            switch (type.toLowerCase(Locale.ROOT)) {
                case "grid": {
                    return GRID;
                }
                case "point": {
                    return POINT;
                }
                case "centroid": {
                    return CENTROID;
                }
            }
            throw new IllegalArgumentException("Invalid grid type [" + type + "]");
        }
    }
}

