/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectortile.rest;

import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import com.wdtinc.mapbox_vector_tile.encoding.MvtValue;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;

class VectorTileUtils {
    private VectorTileUtils() {
    }

    public static VectorTile.Tile.Layer.Builder createLayerBuilder(String layerName, int extent) {
        VectorTile.Tile.Layer.Builder layerBuilder = VectorTile.Tile.Layer.newBuilder();
        layerBuilder.setVersion(2);
        layerBuilder.setName(layerName);
        layerBuilder.setExtent(extent);
        return layerBuilder;
    }

    public static void addToXContentToFeature(VectorTile.Tile.Feature.Builder feature, MvtLayerProps layerProps, ToXContent toXContent) throws IOException {
        Map map = Maps.flatten((Map)((Map)XContentHelper.convertToMap((BytesReference)XContentHelper.toXContent((ToXContent)toXContent, (XContentType)XContentType.CBOR, (boolean)false), (boolean)true, (XContentType)XContentType.CBOR).v2()), (boolean)true, (boolean)true);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            VectorTileUtils.addPropertyToFeature(feature, layerProps, (String)entry.getKey(), entry.getValue());
        }
    }

    public static void addPropertyToFeature(VectorTile.Tile.Feature.Builder feature, MvtLayerProps layerProps, String key, Object value) {
        feature.addTags(layerProps.addKey(key));
        feature.addTags(layerProps.addValue(value));
    }

    public static void addPropertiesToLayer(VectorTile.Tile.Layer.Builder layer, MvtLayerProps layerProps) {
        layer.addAllKeys(layerProps.getKeys());
        Iterable values = layerProps.getVals();
        for (Object value : values) {
            layer.addValues(MvtValue.toValue(value));
        }
    }
}

