/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.enrollment;

import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.common.ssl.StoreKeyConfig;
import org.elasticsearch.common.ssl.StoredCertificate;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportInfo;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.action.enrollment.NodeEnrollmentRequest;
import org.elasticsearch.xpack.core.security.action.enrollment.NodeEnrollmentResponse;
import org.elasticsearch.xpack.core.ssl.SSLService;

public class TransportNodeEnrollmentAction
extends HandledTransportAction<NodeEnrollmentRequest, NodeEnrollmentResponse> {
    private final SSLService sslService;
    private final Client client;

    @Inject
    public TransportNodeEnrollmentAction(TransportService transportService, SSLService sslService, Client client, ActionFilters actionFilters) {
        super("cluster:admin/xpack/security/enroll/node", transportService, actionFilters, NodeEnrollmentRequest::new);
        this.sslService = sslService;
        this.client = client;
    }

    protected void doExecute(Task task, NodeEnrollmentRequest request, ActionListener<NodeEnrollmentResponse> listener) {
        List transportCaCertificates;
        SslKeyConfig transportKeyConfig = this.sslService.getTransportSSLConfiguration().getKeyConfig();
        SslKeyConfig httpKeyConfig = this.sslService.getHttpTransportSSLConfiguration().getKeyConfig();
        if (!(transportKeyConfig instanceof StoreKeyConfig)) {
            listener.onFailure((Exception)new IllegalStateException("Unable to enroll node. Elasticsearch node transport layer SSL configuration is not configured with a keystore"));
            return;
        }
        if (!(httpKeyConfig instanceof StoreKeyConfig)) {
            listener.onFailure((Exception)new IllegalStateException("Unable to enroll node. Elasticsearch node HTTP layer SSL configuration is not configured with a keystore"));
            return;
        }
        List transportKeysAndCertificates = transportKeyConfig.getKeys();
        List httpCaKeysAndCertificates = httpKeyConfig.getKeys().stream().filter(t -> ((X509Certificate)t.v2()).getBasicConstraints() != -1).collect(Collectors.toUnmodifiableList());
        if (transportKeysAndCertificates.isEmpty()) {
            listener.onFailure((Exception)new IllegalStateException("Unable to enroll node. Elasticsearch node transport layer SSL configuration doesn't contain any keys"));
            return;
        }
        if (transportKeysAndCertificates.size() > 1) {
            listener.onFailure((Exception)new IllegalStateException("Unable to enroll node. Elasticsearch node transport layer SSL configuration contains multiple keys"));
            return;
        }
        try {
            transportCaCertificates = ((StoreKeyConfig)transportKeyConfig).getConfiguredCertificates().stream().map(StoredCertificate::getCertificate).filter(x509Certificate -> x509Certificate.getBasicConstraints() != -1).collect(Collectors.toList());
        }
        catch (Exception e) {
            listener.onFailure((Exception)((Object)new ElasticsearchException("Unable to enroll node. Cannot retrieve CA certificate for the transport layer of the Elasticsearch node.", (Throwable)e, new Object[0])));
            return;
        }
        if (transportCaCertificates.size() != 1) {
            listener.onFailure((Exception)((Object)new ElasticsearchException("Unable to enroll Elasticsearch node. Elasticsearch node transport layer SSL configuration Keystore [xpack.security.transport.ssl.keystore] doesn't contain a single CA certificate", new Object[0])));
        }
        if (httpCaKeysAndCertificates.isEmpty()) {
            listener.onFailure((Exception)new IllegalStateException("Unable to enroll node. Elasticsearch node HTTP layer SSL configuration Keystore doesn't contain any PrivateKey entries where the associated certificate is a CA certificate"));
            return;
        }
        if (httpCaKeysAndCertificates.size() > 1) {
            listener.onFailure((Exception)new IllegalStateException("Unable to enroll node. Elasticsearch node HTTP layer SSL configuration Keystore contain multiple PrivateKey entries where the associated certificate is a CA certificate"));
            return;
        }
        ArrayList nodeList = new ArrayList();
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(new String[0]).addMetric(NodesInfoRequest.Metric.TRANSPORT.metricName());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)NodesInfoAction.INSTANCE, (ActionRequest)nodesInfoRequest, (ActionListener)ActionListener.wrap(response -> {
            for (NodeInfo nodeInfo : response.getNodes()) {
                nodeList.add(((TransportInfo)nodeInfo.getInfo(TransportInfo.class)).getAddress().publishAddress().toString());
            }
            try {
                String httpCaKey = Base64.getEncoder().encodeToString(((PrivateKey)((Tuple)httpCaKeysAndCertificates.get(0)).v1()).getEncoded());
                String httpCaCert = Base64.getEncoder().encodeToString(((X509Certificate)((Tuple)httpCaKeysAndCertificates.get(0)).v2()).getEncoded());
                String transportCaCert = Base64.getEncoder().encodeToString(((X509Certificate)transportCaCertificates.get(0)).getEncoded());
                String transportKey = Base64.getEncoder().encodeToString(((PrivateKey)((Tuple)transportKeysAndCertificates.get(0)).v1()).getEncoded());
                String transportCert = Base64.getEncoder().encodeToString(((X509Certificate)((Tuple)transportKeysAndCertificates.get(0)).v2()).getEncoded());
                listener.onResponse((Object)new NodeEnrollmentResponse(httpCaKey, httpCaCert, transportCaCert, transportKey, transportCert, nodeList));
            }
            catch (CertificateEncodingException e) {
                listener.onFailure((Exception)((Object)new ElasticsearchException("Unable to enroll node", (Throwable)e, new Object[0])));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

