/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountToken;

class ServiceAccountAuthenticator
implements Authenticator {
    private static final Logger logger = LogManager.getLogger(ServiceAccountAuthenticator.class);
    private final ServiceAccountService serviceAccountService;
    private final String nodeName;

    ServiceAccountAuthenticator(ServiceAccountService serviceAccountService, String nodeName) {
        this.serviceAccountService = serviceAccountService;
        this.nodeName = nodeName;
    }

    @Override
    public String name() {
        return "service account";
    }

    @Override
    public AuthenticationToken extractCredentials(Authenticator.Context context) {
        SecureString bearerString = context.getBearerString();
        if (bearerString == null) {
            return null;
        }
        return ServiceAccountService.tryParseToken(bearerString);
    }

    @Override
    public void authenticate(Authenticator.Context context, ActionListener<AuthenticationResult<Authentication>> listener) {
        AuthenticationToken authenticationToken = context.getMostRecentAuthenticationToken();
        if (!(authenticationToken instanceof ServiceAccountToken)) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
            return;
        }
        ServiceAccountToken serviceAccountToken = (ServiceAccountToken)authenticationToken;
        this.serviceAccountService.authenticateToken(serviceAccountToken, this.nodeName, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
            assert (authentication != null) : "service account authenticate should return either authentication or call onFailure";
            listener.onResponse((Object)AuthenticationResult.success((Object)authentication));
        }, e -> {
            logger.debug((Message)new ParameterizedMessage("Failed to validate service account token for request [{}]", (Object)context.getRequest()), (Throwable)e);
            listener.onFailure((Exception)((Object)context.getRequest().exceptionProcessingRequest((Exception)e, serviceAccountToken)));
        }));
    }
}

