/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.service.ServiceAccount;

final class ElasticServiceAccounts {
    static final String NAMESPACE = "elastic";
    private static final ServiceAccount FLEET_ACCOUNT = new ElasticServiceAccount("fleet-server", new RoleDescriptor("elastic/fleet-server", new String[]{"monitor", "manage_own_api_key"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"logs-*", "metrics-*", "traces-*", "synthetics-*", ".logs-endpoint.diagnostic.collection-*", ".logs-endpoint.action.responses-*"}).privileges(new String[]{"write", "create_index", "auto_configure"}).build(), RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{".fleet-*"}).privileges(new String[]{"read", "write", "monitor", "create_index", "auto_configure"}).allowRestrictedIndices(true).build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources(new String[]{"*"}).privileges(new String[]{"reserved_fleet-setup"}).build()}, null, null, null, null));
    private static final ServiceAccount KIBANA_SYSTEM_ACCOUNT = new ElasticServiceAccount("kibana", ReservedRolesStore.kibanaSystemRoleDescriptor((String)"elastic/kibana"));
    static final Map<String, ServiceAccount> ACCOUNTS = List.of(FLEET_ACCOUNT, KIBANA_SYSTEM_ACCOUNT).stream().collect(Collectors.toMap(a -> a.id().asPrincipal(), Function.identity()));

    private ElasticServiceAccounts() {
    }

    static class ElasticServiceAccount
    implements ServiceAccount {
        private final ServiceAccount.ServiceAccountId id;
        private final RoleDescriptor roleDescriptor;
        private final User user;

        ElasticServiceAccount(String serviceName, RoleDescriptor roleDescriptor) {
            this.id = new ServiceAccount.ServiceAccountId(ElasticServiceAccounts.NAMESPACE, serviceName);
            this.roleDescriptor = Objects.requireNonNull(roleDescriptor, "Role descriptor cannot be null");
            if (!roleDescriptor.getName().equals(this.id.asPrincipal())) {
                throw new IllegalArgumentException("the provided role descriptor [" + roleDescriptor.getName() + "] must have the same name as the service account [" + this.id.asPrincipal() + "]");
            }
            this.user = new User(this.id.asPrincipal(), Strings.EMPTY_ARRAY, "Service account - " + this.id, null, Map.of("_elastic_service_account", true), true);
        }

        @Override
        public ServiceAccount.ServiceAccountId id() {
            return this.id;
        }

        @Override
        public RoleDescriptor roleDescriptor() {
            return this.roleDescriptor;
        }

        @Override
        public User asUser() {
            return this.user;
        }
    }
}

