/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene86;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.bkd.BKDReader;

public class Lucene86PointsReader
extends PointsReader {
    final IndexInput indexIn;
    final IndexInput dataIn;
    final SegmentReadState readState;
    final Map<Integer, BKDReader> readers = new HashMap<Integer, BKDReader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene86PointsReader(SegmentReadState readState) throws IOException {
        this.readState = readState;
        String metaFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"kdm");
        String indexFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"kdi");
        String dataFileName = IndexFileNames.segmentFileName((String)readState.segmentInfo.name, (String)readState.segmentSuffix, (String)"kdd");
        boolean success = false;
        try {
            long dataLength;
            long indexLength;
            block15: {
                this.indexIn = EndiannessReverserUtil.openInput(readState.directory, indexFileName, readState.context);
                CodecUtil.checkIndexHeader((DataInput)this.indexIn, (String)"Lucene86PointsFormatIndex", (int)0, (int)0, (byte[])readState.segmentInfo.getId(), (String)readState.segmentSuffix);
                this.dataIn = EndiannessReverserUtil.openInput(readState.directory, dataFileName, readState.context);
                CodecUtil.checkIndexHeader((DataInput)this.dataIn, (String)"Lucene86PointsFormatData", (int)0, (int)0, (byte[])readState.segmentInfo.getId(), (String)readState.segmentSuffix);
                indexLength = -1L;
                dataLength = -1L;
                try (ChecksumIndexInput metaIn = EndiannessReverserUtil.openChecksumInput(readState.directory, metaFileName, readState.context);){
                    Throwable priorE = null;
                    try {
                        int fieldNumber;
                        CodecUtil.checkIndexHeader((DataInput)metaIn, (String)"Lucene86PointsFormatMeta", (int)0, (int)0, (byte[])readState.segmentInfo.getId(), (String)readState.segmentSuffix);
                        while ((fieldNumber = metaIn.readInt()) != -1) {
                            if (fieldNumber < 0) {
                                throw new CorruptIndexException("Illegal field number: " + fieldNumber, (DataInput)metaIn);
                            }
                            BKDReader reader = new BKDReader((IndexInput)metaIn, this.indexIn, this.dataIn);
                            this.readers.put(fieldNumber, reader);
                        }
                        indexLength = metaIn.readLong();
                        dataLength = metaIn.readLong();
                    }
                    catch (Throwable t) {
                        try {
                            priorE = t;
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                        }
                    }
                    CodecUtil.checkFooter((ChecksumIndexInput)metaIn, (Throwable)priorE);
                }
            }
            CodecUtil.retrieveChecksum((IndexInput)this.indexIn, (long)indexLength);
            CodecUtil.retrieveChecksum((IndexInput)this.dataIn, (long)dataLength);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    public PointValues getValues(String fieldName) {
        FieldInfo fieldInfo = this.readState.fieldInfos.fieldInfo(fieldName);
        if (fieldInfo == null) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" is unrecognized");
        }
        if (fieldInfo.getPointDimensionCount() == 0) {
            throw new IllegalArgumentException("field=\"" + fieldName + "\" did not index point values");
        }
        return (PointValues)this.readers.get(fieldInfo.number);
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.indexIn);
        CodecUtil.checksumEntireFile((IndexInput)this.dataIn);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.indexIn, this.dataIn});
        this.readers.clear();
    }
}

