/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotShardStats;

public class SearchableSnapshotsStatsResponse
extends BroadcastResponse {
    private List<SearchableSnapshotShardStats> stats;
    private volatile List<SearchableSnapshotShardStats.CacheIndexInputStats> total;

    SearchableSnapshotsStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.stats = in.readList(SearchableSnapshotShardStats::new);
    }

    SearchableSnapshotsStatsResponse(List<SearchableSnapshotShardStats> stats, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.stats = Objects.requireNonNull(stats);
    }

    public List<SearchableSnapshotShardStats> getStats() {
        return this.stats;
    }

    private List<SearchableSnapshotShardStats.CacheIndexInputStats> getTotal() {
        if (this.total != null) {
            return this.total;
        }
        this.total = SearchableSnapshotsStatsResponse.computeCompound(this.getStats().stream().flatMap(stat -> stat.getStats().stream()));
        return this.total;
    }

    private static List<SearchableSnapshotShardStats.CacheIndexInputStats> computeCompound(Stream<SearchableSnapshotShardStats.CacheIndexInputStats> statsStream) {
        return statsStream.collect(Collectors.groupingBy(SearchableSnapshotShardStats.CacheIndexInputStats::getFileExt, Collectors.reducing(SearchableSnapshotShardStats.CacheIndexInputStats::combine))).values().stream().filter(o -> !o.isEmpty()).map(Optional::get).sorted(Comparator.comparing(SearchableSnapshotShardStats.CacheIndexInputStats::getFileExt)).collect(Collectors.toList());
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.stats);
    }

    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean isLevelValid;
        String level = params.param("level", "indices");
        boolean bl = isLevelValid = "cluster".equalsIgnoreCase(level) || "indices".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level);
        if (!isLevelValid) {
            throw new IllegalArgumentException("level parameter must be one of [cluster] or [indices] or [shards] but was [" + level + "]");
        }
        builder.startArray("total");
        for (SearchableSnapshotShardStats.CacheIndexInputStats cis : this.getTotal()) {
            cis.toXContent(builder, params);
        }
        builder.endArray();
        if ("indices".equalsIgnoreCase(level) || "shards".equalsIgnoreCase(level)) {
            builder.startObject("indices");
            List indices = this.getStats().stream().filter(stats -> !stats.getStats().isEmpty()).map(SearchableSnapshotShardStats::getShardRouting).map(ShardRouting::index).sorted(Comparator.comparing(Index::getName)).distinct().collect(Collectors.toList());
            for (Index index : indices) {
                builder.startObject(index.getName());
                builder.startArray("total");
                List<SearchableSnapshotShardStats.CacheIndexInputStats> indexStats = SearchableSnapshotsStatsResponse.computeCompound(this.getStats().stream().filter(dirStats -> dirStats.getShardRouting().index().equals((Object)index)).flatMap(dirStats -> dirStats.getStats().stream()));
                for (SearchableSnapshotShardStats.CacheIndexInputStats cis : indexStats) {
                    cis.toXContent(builder, params);
                }
                builder.endArray();
                if ("shards".equalsIgnoreCase(level)) {
                    builder.startObject("shards");
                    List listOfStats = this.getStats().stream().filter(dirStats -> dirStats.getShardRouting().index().equals((Object)index)).sorted(Comparator.comparingInt(dir -> dir.getShardRouting().getId())).collect(Collectors.toList());
                    int minShard = listOfStats.stream().map(stat -> stat.getShardRouting().getId()).min(Integer::compareTo).orElse(0);
                    int maxShard = listOfStats.stream().map(stat -> stat.getShardRouting().getId()).max(Integer::compareTo).orElse(0);
                    for (int i = minShard; i <= maxShard; ++i) {
                        builder.startArray(Integer.toString(i));
                        for (SearchableSnapshotShardStats stat2 : listOfStats) {
                            if (stat2.getShardRouting().getId() != i) continue;
                            stat2.toXContent(builder, params);
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
        }
    }
}

