/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.rest.action.search.RestMultiSearchAction;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.script.mustache.MultiSearchTemplateAction;
import org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestMultiSearchTemplateAction
extends BaseRestHandler {
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Specifying types in multi search template requests is deprecated.";
    private static final Set<String> RESPONSE_PARAMS;
    private final boolean allowExplicitIndex;

    public RestMultiSearchTemplateAction(Settings settings) {
        this.allowExplicitIndex = (Boolean)MULTI_ALLOW_EXPLICIT_INDEX.get(settings);
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/_msearch/template"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_msearch/template"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_msearch/template"), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/{index}/{type}/_msearch/template").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/{index}/{type}/_msearch/template").deprecated(TYPES_DEPRECATION_MESSAGE, RestApiVersion.V_7).build());
    }

    public String getName() {
        return "multi_search_template_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MultiSearchTemplateRequest multiRequest = RestMultiSearchTemplateAction.parseRequest(request, this.allowExplicitIndex);
        return channel -> client.execute((ActionType)MultiSearchTemplateAction.INSTANCE, (ActionRequest)multiRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public static MultiSearchTemplateRequest parseRequest(RestRequest restRequest, boolean allowExplicitIndex) throws IOException {
        if (restRequest.getRestApiVersion() == RestApiVersion.V_7 && restRequest.hasParam("type")) {
            restRequest.param("type");
        }
        MultiSearchTemplateRequest multiRequest = new MultiSearchTemplateRequest();
        if (restRequest.hasParam("max_concurrent_searches")) {
            multiRequest.maxConcurrentSearchRequests(restRequest.paramAsInt("max_concurrent_searches", 0));
        }
        RestMultiSearchAction.parseMultiLineRequest((RestRequest)restRequest, (IndicesOptions)multiRequest.indicesOptions(), (boolean)allowExplicitIndex, (searchRequest, bytes) -> {
            SearchTemplateRequest searchTemplateRequest = SearchTemplateRequest.fromXContent(bytes);
            if (searchTemplateRequest.getScript() == null) {
                throw new IllegalArgumentException("Malformed search template");
            }
            searchTemplateRequest.setRequest((SearchRequest)searchRequest);
            multiRequest.add(searchTemplateRequest);
            RestSearchAction.checkRestTotalHits((RestRequest)restRequest, (SearchRequest)searchRequest);
        });
        return multiRequest;
    }

    public boolean supportsContentStream() {
        return true;
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("typed_keys", "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

