/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.sql.execution.PlanExecutor;
import org.elasticsearch.xpack.sql.plugin.SqlStatsRequest;
import org.elasticsearch.xpack.sql.plugin.SqlStatsResponse;

public class TransportSqlStatsAction
extends TransportNodesAction<SqlStatsRequest, SqlStatsResponse, SqlStatsRequest.NodeStatsRequest, SqlStatsResponse.NodeStatsResponse> {
    private final PlanExecutor planExecutor;

    @Inject
    public TransportSqlStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PlanExecutor planExecutor) {
        super("cluster:monitor/xpack/sql/stats/dist", threadPool, clusterService, transportService, actionFilters, SqlStatsRequest::new, SqlStatsRequest.NodeStatsRequest::new, "management", SqlStatsResponse.NodeStatsResponse.class);
        this.planExecutor = planExecutor;
    }

    protected SqlStatsResponse newResponse(SqlStatsRequest request, List<SqlStatsResponse.NodeStatsResponse> nodes, List<FailedNodeException> failures) {
        return new SqlStatsResponse(this.clusterService.getClusterName(), nodes, failures);
    }

    protected SqlStatsRequest.NodeStatsRequest newNodeRequest(SqlStatsRequest request) {
        return new SqlStatsRequest.NodeStatsRequest(request);
    }

    protected SqlStatsResponse.NodeStatsResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new SqlStatsResponse.NodeStatsResponse(in);
    }

    protected SqlStatsResponse.NodeStatsResponse nodeOperation(SqlStatsRequest.NodeStatsRequest request, Task task) {
        SqlStatsResponse.NodeStatsResponse statsResponse = new SqlStatsResponse.NodeStatsResponse(this.clusterService.localNode());
        statsResponse.setStats(this.planExecutor.metrics().stats());
        return statsResponse;
    }
}

