/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.action.StopSLMAction;
import org.elasticsearch.xpack.ilm.OperationModeUpdateTask;

public class TransportStopSLMAction
extends AcknowledgedTransportMasterNodeAction<StopSLMAction.Request> {
    @Inject
    public TransportStopSLMAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/stop", transportService, clusterService, threadPool, actionFilters, StopSLMAction.Request::new, indexNameExpressionResolver, "same");
    }

    protected void masterOperation(Task task, StopSLMAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("slm_operation_mode_update", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask((AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                return OperationModeUpdateTask.slmMode(OperationMode.STOPPING).execute(currentState);
            }
        });
    }

    protected ClusterBlockException checkBlock(StopSLMAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

