/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.watcher.common.http.Scheme;

public class HttpSettings {
    private static final TimeValue DEFAULT_READ_TIMEOUT;
    private static final TimeValue DEFAULT_CONNECTION_TIMEOUT;
    static final Setting<TimeValue> READ_TIMEOUT;
    static final Setting<TimeValue> CONNECTION_TIMEOUT;
    static final Setting<Boolean> TCP_KEEPALIVE;
    static final Setting<TimeValue> CONNECTION_POOL_TTL;
    private static final String PROXY_HOST_KEY = "xpack.http.proxy.host";
    private static final String PROXY_PORT_KEY = "xpack.http.proxy.port";
    private static final String PROXY_SCHEME_KEY = "xpack.http.proxy.scheme";
    private static final String SSL_KEY_PREFIX = "xpack.http.ssl.";
    static final Setting<String> PROXY_HOST;
    static final Setting<String> PROXY_SCHEME;
    static final Setting<Integer> PROXY_PORT;
    static final Setting<List<String>> HOSTS_WHITELIST;
    static final Setting<ByteSizeValue> MAX_HTTP_RESPONSE_SIZE;
    private static final SSLConfigurationSettings SSL;

    public static List<? extends Setting<?>> getSettings() {
        ArrayList<Object> settings = new ArrayList<Object>();
        settings.addAll(SSL.getEnabledSettings());
        settings.add(READ_TIMEOUT);
        settings.add(CONNECTION_TIMEOUT);
        settings.add(TCP_KEEPALIVE);
        settings.add(CONNECTION_POOL_TTL);
        settings.add(PROXY_HOST);
        settings.add(PROXY_PORT);
        settings.add(PROXY_SCHEME);
        settings.add(MAX_HTTP_RESPONSE_SIZE);
        settings.add(HOSTS_WHITELIST);
        return settings;
    }

    private HttpSettings() {
    }

    static {
        DEFAULT_CONNECTION_TIMEOUT = DEFAULT_READ_TIMEOUT = TimeValue.timeValueSeconds((long)10L);
        READ_TIMEOUT = Setting.timeSetting((String)"xpack.http.default_read_timeout", (TimeValue)DEFAULT_READ_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        CONNECTION_TIMEOUT = Setting.timeSetting((String)"xpack.http.default_connection_timeout", (TimeValue)DEFAULT_CONNECTION_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        TCP_KEEPALIVE = Setting.boolSetting((String)"xpack.http.tcp.keep_alive", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        CONNECTION_POOL_TTL = Setting.timeSetting((String)"xpack.http.connection_pool_ttl", (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        PROXY_HOST = Setting.simpleString((String)PROXY_HOST_KEY, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        PROXY_SCHEME = Setting.simpleString((String)PROXY_SCHEME_KEY, Scheme::parse, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        PROXY_PORT = Setting.intSetting((String)PROXY_PORT_KEY, (int)0, (int)0, (int)65535, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        HOSTS_WHITELIST = Setting.listSetting((String)"xpack.http.whitelist", Collections.singletonList("*"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        MAX_HTTP_RESPONSE_SIZE = Setting.byteSizeSetting((String)"xpack.http.max_response_size", (ByteSizeValue)new ByteSizeValue(10L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(1L, ByteSizeUnit.BYTES), (ByteSizeValue)new ByteSizeValue(50L, ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        SSL = SSLConfigurationSettings.withPrefix((String)SSL_KEY_PREFIX, (boolean)true);
    }
}

