/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.Packed64;
import org.apache.lucene.util.packed.Packed64SingleBlock;
import org.apache.lucene.util.packed.PackedReaderIterator;
import org.apache.lucene.util.packed.PackedWriter;

public class PackedInts {
    public static final float FASTEST = 7.0f;
    public static final float FAST = 0.5f;
    public static final float DEFAULT = 0.25f;
    public static final float COMPACT = 0.0f;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final String CODEC_NAME = "PackedInts";
    public static final int VERSION_MONOTONIC_WITHOUT_ZIGZAG = 2;
    public static final int VERSION_START = 2;
    public static final int VERSION_CURRENT = 2;

    public static void checkVersion(int version) {
        if (version < 2) {
            throw new IllegalArgumentException("Version is too old, should be at least 2 (got " + version + ")");
        }
        if (version > 2) {
            throw new IllegalArgumentException("Version is too new, should be at most 2 (got " + version + ")");
        }
    }

    public static FormatAndBits fastestFormatAndBits(int valueCount, int bitsPerValue, float acceptableOverheadRatio) {
        if (valueCount == -1) {
            valueCount = Integer.MAX_VALUE;
        }
        acceptableOverheadRatio = Math.max(0.0f, acceptableOverheadRatio);
        acceptableOverheadRatio = Math.min(7.0f, acceptableOverheadRatio);
        float acceptableOverheadPerValue = acceptableOverheadRatio * (float)bitsPerValue;
        int maxBitsPerValue = bitsPerValue + (int)acceptableOverheadPerValue;
        int actualBitsPerValue = -1;
        actualBitsPerValue = bitsPerValue <= 8 && maxBitsPerValue >= 8 ? 8 : (bitsPerValue <= 16 && maxBitsPerValue >= 16 ? 16 : (bitsPerValue <= 32 && maxBitsPerValue >= 32 ? 32 : (bitsPerValue <= 64 && maxBitsPerValue >= 64 ? 64 : bitsPerValue)));
        return new FormatAndBits(Format.PACKED, actualBitsPerValue);
    }

    public static Decoder getDecoder(Format format, int version, int bitsPerValue) {
        PackedInts.checkVersion(version);
        return BulkOperation.of(format, bitsPerValue);
    }

    public static Encoder getEncoder(Format format, int version, int bitsPerValue) {
        PackedInts.checkVersion(version);
        return BulkOperation.of(format, bitsPerValue);
    }

    public static ReaderIterator getReaderIteratorNoHeader(DataInput in, Format format, int version, int valueCount, int bitsPerValue, int mem) {
        PackedInts.checkVersion(version);
        return new PackedReaderIterator(format, version, valueCount, bitsPerValue, in, mem);
    }

    public static Mutable getMutable(int valueCount, int bitsPerValue, float acceptableOverheadRatio) {
        FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits(valueCount, bitsPerValue, acceptableOverheadRatio);
        return PackedInts.getMutable(valueCount, formatAndBits.bitsPerValue, formatAndBits.format);
    }

    public static Mutable getMutable(int valueCount, int bitsPerValue, Format format) {
        assert (valueCount >= 0);
        switch (format) {
            case PACKED_SINGLE_BLOCK: {
                return Packed64SingleBlock.create(valueCount, bitsPerValue);
            }
            case PACKED: {
                return new Packed64(valueCount, bitsPerValue);
            }
        }
        throw new AssertionError();
    }

    public static Writer getWriterNoHeader(DataOutput out, Format format, int valueCount, int bitsPerValue, int mem) {
        return new PackedWriter(format, out, valueCount, bitsPerValue, mem);
    }

    public static int bitsRequired(long maxValue) {
        if (maxValue < 0L) {
            throw new IllegalArgumentException("maxValue must be non-negative (got: " + maxValue + ")");
        }
        return PackedInts.unsignedBitsRequired(maxValue);
    }

    public static int unsignedBitsRequired(long bits) {
        return Math.max(1, 64 - Long.numberOfLeadingZeros(bits));
    }

    public static long maxValue(int bitsPerValue) {
        return bitsPerValue == 64 ? Long.MAX_VALUE : -1L << bitsPerValue ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void copy(Reader src, int srcPos, Mutable dest, int destPos, int len, int mem) {
        assert (srcPos + len <= src.size());
        assert (destPos + len <= dest.size());
        int capacity = mem >>> 3;
        if (capacity == 0) {
            for (int i = 0; i < len; ++i) {
                dest.set(destPos++, src.get(srcPos++));
            }
        } else if (len > 0) {
            long[] buf = new long[Math.min(capacity, len)];
            PackedInts.copy(src, srcPos, dest, destPos, len, buf);
        }
    }

    static void copy(Reader src, int srcPos, Mutable dest, int destPos, int len, long[] buf) {
        assert (buf.length > 0);
        int remaining = 0;
        while (len > 0) {
            int read = src.get(srcPos, buf, remaining, Math.min(len, buf.length - remaining));
            assert (read > 0);
            srcPos += read;
            len -= read;
            int written = dest.set(destPos, buf, 0, remaining += read);
            assert (written > 0);
            destPos += written;
            if (written < remaining) {
                System.arraycopy(buf, written, buf, 0, remaining - written);
            }
            remaining -= written;
        }
        while (remaining > 0) {
            int written = dest.set(destPos, buf, 0, remaining);
            destPos += written;
            System.arraycopy(buf, written, buf, 0, remaining -= written);
        }
    }

    static int checkBlockSize(int blockSize, int minBlockSize, int maxBlockSize) {
        if (blockSize < minBlockSize || blockSize > maxBlockSize) {
            throw new IllegalArgumentException("blockSize must be >= " + minBlockSize + " and <= " + maxBlockSize + ", got " + blockSize);
        }
        if ((blockSize & blockSize - 1) != 0) {
            throw new IllegalArgumentException("blockSize must be a power of two, got " + blockSize);
        }
        return Integer.numberOfTrailingZeros(blockSize);
    }

    static int numBlocks(long size, int blockSize) {
        int numBlocks = (int)(size / (long)blockSize) + (size % (long)blockSize == 0L ? 0 : 1);
        if ((long)numBlocks * (long)blockSize < size) {
            throw new IllegalArgumentException("size is too large for this block size");
        }
        return numBlocks;
    }

    public static class FormatAndBits {
        public final Format format;
        public final int bitsPerValue;

        public FormatAndBits(Format format, int bitsPerValue) {
            this.format = format;
            this.bitsPerValue = bitsPerValue;
        }

        public String toString() {
            return "FormatAndBits(format=" + this.format + " bitsPerValue=" + this.bitsPerValue + ")";
        }
    }

    public static class Format
    extends Enum<Format> {
        public static final /* enum */ Format PACKED = new Format(0){

            @Override
            public long byteCount(int packedIntsVersion, int valueCount, int bitsPerValue) {
                return (long)Math.ceil((double)valueCount * (double)bitsPerValue / 8.0);
            }
        };
        @Deprecated
        public static final /* enum */ Format PACKED_SINGLE_BLOCK = new Format(1){

            @Override
            public int longCount(int packedIntsVersion, int valueCount, int bitsPerValue) {
                int valuesPerBlock = 64 / bitsPerValue;
                return (int)Math.ceil((double)valueCount / (double)valuesPerBlock);
            }

            @Override
            public boolean isSupported(int bitsPerValue) {
                return Packed64SingleBlock.isSupported(bitsPerValue);
            }

            @Override
            public float overheadPerValue(int bitsPerValue) {
                assert (this.isSupported(bitsPerValue));
                int valuesPerBlock = 64 / bitsPerValue;
                int overhead = 64 % bitsPerValue;
                return (float)overhead / (float)valuesPerBlock;
            }
        };
        public final int id;
        private static final /* synthetic */ Format[] $VALUES;

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String name) {
            return Enum.valueOf(Format.class, name);
        }

        public static Format byId(int id) {
            for (Format format : Format.values()) {
                if (format.getId() != id) continue;
                return format;
            }
            throw new IllegalArgumentException("Unknown format id: " + id);
        }

        private Format(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public long byteCount(int packedIntsVersion, int valueCount, int bitsPerValue) {
            assert (bitsPerValue >= 0 && bitsPerValue <= 64) : bitsPerValue;
            return 8L * (long)this.longCount(packedIntsVersion, valueCount, bitsPerValue);
        }

        public int longCount(int packedIntsVersion, int valueCount, int bitsPerValue) {
            assert (bitsPerValue >= 0 && bitsPerValue <= 64) : bitsPerValue;
            long byteCount = this.byteCount(packedIntsVersion, valueCount, bitsPerValue);
            assert (byteCount < 0x3FFFFFFF8L);
            if (byteCount % 8L == 0L) {
                return (int)(byteCount / 8L);
            }
            return (int)(byteCount / 8L + 1L);
        }

        public boolean isSupported(int bitsPerValue) {
            return bitsPerValue >= 1 && bitsPerValue <= 64;
        }

        public float overheadPerValue(int bitsPerValue) {
            assert (this.isSupported(bitsPerValue));
            return 0.0f;
        }

        public final float overheadRatio(int bitsPerValue) {
            assert (this.isSupported(bitsPerValue));
            return this.overheadPerValue(bitsPerValue) / (float)bitsPerValue;
        }

        private static /* synthetic */ Format[] $values() {
            return new Format[]{PACKED, PACKED_SINGLE_BLOCK};
        }

        static {
            $VALUES = Format.$values();
        }
    }

    public static abstract class Mutable
    extends Reader {
        public abstract int getBitsPerValue();

        public abstract void set(int var1, long var2);

        public int set(int index, long[] arr, int off, int len) {
            assert (len > 0) : "len must be > 0 (got " + len + ")";
            assert (index >= 0 && index < this.size());
            len = Math.min(len, this.size() - index);
            assert (off + len <= arr.length);
            int i = index;
            int o = off;
            int end = index + len;
            while (i < end) {
                this.set(i, arr[o]);
                ++i;
                ++o;
            }
            return len;
        }

        public void fill(int fromIndex, int toIndex, long val) {
            assert (val <= PackedInts.maxValue(this.getBitsPerValue()));
            assert (fromIndex <= toIndex);
            for (int i = fromIndex; i < toIndex; ++i) {
                this.set(i, val);
            }
        }

        public void clear() {
            this.fill(0, this.size(), 0L);
        }
    }

    public static abstract class Reader
    implements Accountable {
        public abstract long get(int var1);

        public int get(int index, long[] arr, int off, int len) {
            assert (len > 0) : "len must be > 0 (got " + len + ")";
            assert (index >= 0 && index < this.size());
            assert (off + len <= arr.length);
            int gets = Math.min(this.size() - index, len);
            int i = index;
            int o = off;
            int end = index + gets;
            while (i < end) {
                arr[o] = this.get(i);
                ++i;
                ++o;
            }
            return gets;
        }

        public abstract int size();
    }

    public static abstract class Writer {
        protected final DataOutput out;
        protected final int valueCount;
        protected final int bitsPerValue;

        protected Writer(DataOutput out, int valueCount, int bitsPerValue) {
            assert (bitsPerValue <= 64);
            assert (valueCount >= 0 || valueCount == -1);
            this.out = out;
            this.valueCount = valueCount;
            this.bitsPerValue = bitsPerValue;
        }

        protected abstract Format getFormat();

        public abstract void add(long var1) throws IOException;

        public final int bitsPerValue() {
            return this.bitsPerValue;
        }

        public abstract void finish() throws IOException;

        public abstract int ord();
    }

    public static final class NullReader
    extends Reader {
        private final int valueCount;

        public NullReader(int valueCount) {
            this.valueCount = valueCount;
        }

        @Override
        public long get(int index) {
            return 0L;
        }

        @Override
        public int get(int index, long[] arr, int off, int len) {
            assert (len > 0) : "len must be > 0 (got " + len + ")";
            assert (index >= 0 && index < this.valueCount);
            len = Math.min(len, this.valueCount - index);
            Arrays.fill(arr, off, off + len, 0L);
            return len;
        }

        @Override
        public int size() {
            return this.valueCount;
        }

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4);
        }
    }

    static abstract class MutableImpl
    extends Mutable {
        protected final int valueCount;
        protected final int bitsPerValue;

        protected MutableImpl(int valueCount, int bitsPerValue) {
            this.valueCount = valueCount;
            assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
            this.bitsPerValue = bitsPerValue;
        }

        @Override
        public final int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @Override
        public final int size() {
            return this.valueCount;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(valueCount=" + this.valueCount + ",bitsPerValue=" + this.bitsPerValue + ")";
        }
    }

    static abstract class ReaderImpl
    extends Reader {
        protected final int valueCount;

        protected ReaderImpl(int valueCount) {
            this.valueCount = valueCount;
        }

        @Override
        public abstract long get(int var1);

        @Override
        public final int size() {
            return this.valueCount;
        }
    }

    static abstract class ReaderIteratorImpl
    implements ReaderIterator {
        protected final DataInput in;
        protected final int bitsPerValue;
        protected final int valueCount;

        protected ReaderIteratorImpl(int valueCount, int bitsPerValue, DataInput in) {
            this.in = in;
            this.bitsPerValue = bitsPerValue;
            this.valueCount = valueCount;
        }

        @Override
        public long next() throws IOException {
            LongsRef nextValues = this.next(1);
            assert (nextValues.length > 0);
            long result = nextValues.longs[nextValues.offset];
            ++nextValues.offset;
            --nextValues.length;
            return result;
        }

        @Override
        public int getBitsPerValue() {
            return this.bitsPerValue;
        }

        @Override
        public int size() {
            return this.valueCount;
        }
    }

    public static interface ReaderIterator {
        public long next() throws IOException;

        public LongsRef next(int var1) throws IOException;

        public int getBitsPerValue();

        public int size();

        public int ord();
    }

    public static interface Encoder {
        public int longBlockCount();

        public int longValueCount();

        public int byteBlockCount();

        public int byteValueCount();

        public void encode(long[] var1, int var2, long[] var3, int var4, int var5);

        public void encode(long[] var1, int var2, byte[] var3, int var4, int var5);

        public void encode(int[] var1, int var2, long[] var3, int var4, int var5);

        public void encode(int[] var1, int var2, byte[] var3, int var4, int var5);
    }

    public static interface Decoder {
        public int longBlockCount();

        public int longValueCount();

        public int byteBlockCount();

        public int byteValueCount();

        public void decode(long[] var1, int var2, long[] var3, int var4, int var5);

        public void decode(byte[] var1, int var2, long[] var3, int var4, int var5);

        public void decode(long[] var1, int var2, int[] var3, int var4, int var5);

        public void decode(byte[] var1, int var2, int[] var3, int var4, int var5);
    }
}

