/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SlowImpactsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.ExactPhraseMatcher;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseMatcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PhraseWeight;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SloppyPhraseMatcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValueBool;

public class PhraseWildcardQuery
extends Query {
    protected static final Query NO_MATCH_QUERY = new MatchNoDocsQuery("Empty " + PhraseWildcardQuery.class.getSimpleName());
    protected final String field;
    protected final List<PhraseTerm> phraseTerms;
    protected final int slop;
    protected final int maxMultiTermExpansions;
    protected final boolean segmentOptimizationEnabled;

    protected PhraseWildcardQuery(String field, List<PhraseTerm> phraseTerms, int slop, int maxMultiTermExpansions, boolean segmentOptimizationEnabled) {
        this.field = field;
        this.phraseTerms = phraseTerms;
        this.slop = slop;
        this.maxMultiTermExpansions = maxMultiTermExpansions;
        this.segmentOptimizationEnabled = segmentOptimizationEnabled;
    }

    public String getField() {
        return this.field;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.phraseTerms.isEmpty()) {
            return NO_MATCH_QUERY;
        }
        if (this.phraseTerms.size() == 1) {
            return this.phraseTerms.get(0).getQuery();
        }
        return super.rewrite(reader);
    }

    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.field)) {
            return;
        }
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this);
        for (PhraseTerm phraseTerm : this.phraseTerms) {
            phraseTerm.getQuery().visit(v);
        }
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        IndexReader reader = searcher.getIndexReader();
        List<LeafReaderContext> sizeSortedSegments = new SegmentTermsSizeComparator().createTermsSizeSortedCopyOf(reader.leaves());
        TermsData termsData = this.createTermsData(sizeSortedSegments.size());
        int numMultiTerms = 0;
        for (PhraseTerm phraseTerm : this.phraseTerms) {
            if (phraseTerm.hasExpansions()) {
                ++numMultiTerms;
                continue;
            }
            assert (TestCounters.get().incSingleTermAnalysisCount());
            int numMatches = phraseTerm.collectTermData(this, searcher, sizeSortedSegments, termsData);
            if (numMatches != 0) continue;
            return this.earlyStopWeight();
        }
        int remainingExpansions = this.maxMultiTermExpansions;
        int remainingMultiTerms = numMultiTerms;
        for (PhraseTerm phraseTerm : this.phraseTerms) {
            if (!phraseTerm.hasExpansions()) continue;
            assert (TestCounters.get().incMultiTermAnalysisCount());
            assert (remainingExpansions >= 0 && remainingExpansions <= this.maxMultiTermExpansions);
            assert (remainingMultiTerms > 0);
            int maxExpansionsForTerm = remainingExpansions / remainingMultiTerms;
            int numExpansions = phraseTerm.collectTermData(this, searcher, sizeSortedSegments, remainingMultiTerms, maxExpansionsForTerm, termsData);
            assert (numExpansions >= 0 && numExpansions <= maxExpansionsForTerm);
            if (numExpansions == 0) {
                return this.earlyStopWeight();
            }
            remainingExpansions -= numExpansions;
            --remainingMultiTerms;
        }
        assert (remainingMultiTerms == 0);
        assert (remainingExpansions >= 0);
        return termsData.areAllTermsMatching() ? this.createPhraseWeight(searcher, scoreMode, boost, termsData) : this.noMatchWeight();
    }

    protected TermsData createTermsData(int numSegments) {
        return new TermsData(this.phraseTerms.size(), numSegments);
    }

    protected Weight earlyStopWeight() {
        assert (TestCounters.get().incQueryEarlyStopCount());
        return this.noMatchWeight();
    }

    protected Weight noMatchWeight() {
        return new ConstantScoreWeight(this, 0.0f){

            public Scorer scorer(LeafReaderContext leafReaderContext) {
                return null;
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    PhraseWeight createPhraseWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost, final TermsData termsData) throws IOException {
        return new PhraseWeight(this, this.field, searcher, scoreMode){

            protected Similarity.SimScorer getStats(IndexSearcher searcher) throws IOException {
                if (termsData.termStatsList.isEmpty()) {
                    return null;
                }
                return searcher.getSimilarity().scorer(boost, searcher.collectionStatistics(PhraseWildcardQuery.this.field), termsData.termStatsList.toArray(new TermStatistics[0]));
            }

            protected PhraseMatcher getPhraseMatcher(LeafReaderContext leafReaderContext, Similarity.SimScorer scorer, boolean exposeOffsets) throws IOException {
                Terms fieldTerms = leafReaderContext.reader().terms(PhraseWildcardQuery.this.field);
                if (fieldTerms == null) {
                    return null;
                }
                TermsEnum termsEnum = fieldTerms.iterator();
                float totalMatchCost = 0.0f;
                PhraseQuery.PostingsAndFreq[] postingsFreqs = new PhraseQuery.PostingsAndFreq[PhraseWildcardQuery.this.phraseTerms.size()];
                for (int termPosition = 0; termPosition < postingsFreqs.length; ++termPosition) {
                    TermData termData = termsData.getTermData(termPosition);
                    assert (termData != null);
                    List<TermBytesTermState> termStates = termData.getTermStatesForSegment(leafReaderContext);
                    if (termStates == null) {
                        return null;
                    }
                    assert (!termStates.isEmpty());
                    ArrayList<PostingsEnum> postingsEnums = new ArrayList<PostingsEnum>(termStates.size());
                    for (TermBytesTermState termBytesTermState : termStates) {
                        termsEnum.seekExact(termBytesTermState.termBytes, termBytesTermState.termState);
                        postingsEnums.add(termsEnum.postings(null, exposeOffsets ? 120 : 24));
                        totalMatchCost += PhraseQuery.termPositionsCost((TermsEnum)termsEnum);
                    }
                    Object unionPostingsEnum = postingsEnums.size() == 1 ? (PostingsEnum)postingsEnums.get(0) : (exposeOffsets ? new MultiPhraseQuery.UnionFullPostingsEnum(postingsEnums) : new MultiPhraseQuery.UnionPostingsEnum(postingsEnums));
                    postingsFreqs[termPosition] = new PhraseQuery.PostingsAndFreq(unionPostingsEnum, (ImpactsEnum)new SlowImpactsEnum(unionPostingsEnum), termPosition, termData.terms);
                }
                if (PhraseWildcardQuery.this.slop == 0) {
                    ArrayUtil.timSort((Comparable[])postingsFreqs);
                    return new ExactPhraseMatcher(postingsFreqs, scoreMode, scorer, totalMatchCost);
                }
                return new SloppyPhraseMatcher(postingsFreqs, PhraseWildcardQuery.this.slop, scoreMode, scorer, totalMatchCost, exposeOffsets);
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof PhraseWildcardQuery)) {
            return false;
        }
        PhraseWildcardQuery pwq = (PhraseWildcardQuery)((Object)o);
        return this.slop == pwq.slop && this.phraseTerms.equals(pwq.phraseTerms);
    }

    public int hashCode() {
        return this.classHash() ^ this.slop ^ this.phraseTerms.hashCode();
    }

    public final String toString(String omittedField) {
        StringBuilder builder = new StringBuilder();
        builder.append("phraseWildcard(");
        if (this.field == null || !this.field.equals(omittedField)) {
            builder.append(this.field).append(':');
        }
        builder.append('\"');
        for (int i = 0; i < this.phraseTerms.size(); ++i) {
            if (i != 0) {
                builder.append(' ');
            }
            this.phraseTerms.get(i).toString(builder);
        }
        builder.append('\"');
        if (this.slop != 0) {
            builder.append('~');
            builder.append(this.slop);
        }
        builder.append(")");
        return builder.toString();
    }

    protected int collectSingleTermData(SingleTerm singleTerm, IndexSearcher searcher, List<LeafReaderContext> segments, TermsData termsData) throws IOException {
        TermData termData = termsData.getOrCreateTermData(singleTerm.termPosition);
        Term term = singleTerm.term;
        termData.terms.add(term);
        TermStates termStates = TermStates.build((IndexReaderContext)searcher.getIndexReader().getContext(), (Term)term, (boolean)true);
        int numMatches = 0;
        Iterator<LeafReaderContext> segmentIterator = segments.iterator();
        while (segmentIterator.hasNext()) {
            LeafReaderContext leafReaderContext = segmentIterator.next();
            assert (TestCounters.get().incSegmentUseCount());
            boolean termMatchesInSegment = false;
            Terms terms = leafReaderContext.reader().terms(term.field());
            if (terms != null) {
                this.checkTermsHavePositions(terms);
                TermState termState = termStates.get(leafReaderContext);
                if (termState != null) {
                    termMatchesInSegment = true;
                    ++numMatches;
                    termData.setTermStatesForSegment(leafReaderContext, Collections.singletonList(new TermBytesTermState(term.bytes(), termState)));
                }
            }
            if (termMatchesInSegment || !this.shouldOptimizeSegments()) continue;
            segmentIterator.remove();
            assert (TestCounters.get().incSegmentSkipCount());
        }
        if (termStates.docFreq() > 0) {
            termsData.termStatsList.add(searcher.termStatistics(term, termStates.docFreq(), termStates.totalTermFreq()));
        }
        return numMatches;
    }

    protected int collectMultiTermData(MultiTerm multiTerm, IndexSearcher searcher, List<LeafReaderContext> segments, int remainingMultiTerms, int maxExpansionsForTerm, TermsData termsData) throws IOException {
        TermData termData = termsData.getOrCreateTermData(multiTerm.termPosition);
        Map<BytesRef, TermStats> termStatsMap = this.createTermStatsMap(multiTerm);
        int numExpansions = 0;
        Iterator<LeafReaderContext> segmentIterator = segments.iterator();
        MutableValueBool shouldStopSegmentIteration = new MutableValueBool();
        while (segmentIterator.hasNext() && !shouldStopSegmentIteration.value) {
            LeafReaderContext leafReaderContext = segmentIterator.next();
            int remainingExpansions = maxExpansionsForTerm - numExpansions;
            assert (remainingExpansions >= 0);
            List<TermBytesTermState> termStates = this.collectMultiTermDataForSegment(multiTerm, leafReaderContext, remainingExpansions, shouldStopSegmentIteration, termStatsMap);
            if (!termStates.isEmpty()) {
                assert (termStates.size() <= remainingExpansions);
                assert ((numExpansions += termStates.size()) <= maxExpansionsForTerm);
                termData.setTermStatesForSegment(leafReaderContext, termStates);
                continue;
            }
            if (!this.shouldOptimizeSegments()) continue;
            segmentIterator.remove();
            assert (TestCounters.get().incSegmentSkipCount());
        }
        this.collectMultiTermStats(searcher, termStatsMap, termsData, termData);
        return numExpansions;
    }

    protected boolean shouldOptimizeSegments() {
        return this.segmentOptimizationEnabled;
    }

    protected Map<BytesRef, TermStats> createTermStatsMap(MultiTerm multiTerm) {
        return new HashMap<BytesRef, TermStats>();
    }

    protected List<TermBytesTermState> collectMultiTermDataForSegment(MultiTerm multiTerm, LeafReaderContext leafReaderContext, int remainingExpansions, MutableValueBool shouldStopSegmentIteration, Map<BytesRef, TermStats> termStatsMap) throws IOException {
        TermsEnum termsEnum = this.createTermsEnum(multiTerm, leafReaderContext);
        if (termsEnum == null) {
            return Collections.emptyList();
        }
        assert (TestCounters.get().incSegmentUseCount());
        ArrayList<TermBytesTermState> termStates = new ArrayList<TermBytesTermState>();
        while (termsEnum.next() != null && remainingExpansions > 0) {
            TermStats termStats = termStatsMap.get(termsEnum.term());
            if (termStats == null) {
                BytesRef termBytes = BytesRef.deepCopyOf((BytesRef)termsEnum.term());
                termStats = new TermStats(termBytes);
                termStatsMap.put(termBytes, termStats);
            }
            termStats.addStats(termsEnum.docFreq(), termsEnum.totalTermFreq());
            termStates.add(new TermBytesTermState(termStats.termBytes, termsEnum.termState()));
            --remainingExpansions;
            assert (TestCounters.get().incExpansionCount());
        }
        assert (remainingExpansions >= 0);
        shouldStopSegmentIteration.value = remainingExpansions == 0;
        return termStates;
    }

    protected TermsEnum createTermsEnum(MultiTerm multiTerm, LeafReaderContext leafReaderContext) throws IOException {
        Terms terms = leafReaderContext.reader().terms(this.field);
        if (terms == null) {
            return null;
        }
        this.checkTermsHavePositions(terms);
        TermsEnum termsEnum = multiTerm.query.getTermsEnum(terms);
        assert (termsEnum != null);
        return termsEnum;
    }

    protected void collectMultiTermStats(IndexSearcher searcher, Map<BytesRef, TermStats> termStatsMap, TermsData termsData, TermData termData) throws IOException {
        for (Map.Entry<BytesRef, TermStats> termStatsEntry : termStatsMap.entrySet()) {
            Term term = new Term(this.field, termStatsEntry.getKey());
            termData.terms.add(term);
            TermStats termStats = termStatsEntry.getValue();
            if (termStats.docFreq <= 0) continue;
            termsData.termStatsList.add(searcher.termStatistics(term, termStats.docFreq, termStats.totalTermFreq));
        }
    }

    protected void checkTermsHavePositions(Terms terms) {
        if (!terms.hasPositions()) {
            throw new IllegalStateException("field \"" + this.field + "\" was indexed without position data; cannot run " + PhraseWildcardQuery.class.getSimpleName());
        }
    }

    protected static abstract class PhraseTerm {
        protected final int termPosition;

        protected PhraseTerm(int termPosition) {
            this.termPosition = termPosition;
        }

        protected abstract boolean hasExpansions();

        protected abstract Query getQuery();

        protected int collectTermData(PhraseWildcardQuery query, IndexSearcher searcher, List<LeafReaderContext> segments, TermsData termsData) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected abstract int collectTermData(PhraseWildcardQuery var1, IndexSearcher var2, List<LeafReaderContext> var3, int var4, int var5, TermsData var6) throws IOException;

        protected abstract void toString(StringBuilder var1);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    protected class SegmentTermsSizeComparator
    implements Comparator<LeafReaderContext> {
        private static final String COMPARISON_ERROR_MESSAGE = "Segment comparison error";

        protected SegmentTermsSizeComparator() {
        }

        @Override
        public int compare(LeafReaderContext leafReaderContext1, LeafReaderContext leafReaderContext2) {
            try {
                return Long.compare(this.getTermsSize(leafReaderContext1), this.getTermsSize(leafReaderContext2));
            }
            catch (IOException e) {
                throw new RuntimeException(COMPARISON_ERROR_MESSAGE, e);
            }
        }

        protected List<LeafReaderContext> createTermsSizeSortedCopyOf(List<LeafReaderContext> segments) throws IOException {
            ArrayList<LeafReaderContext> copy = new ArrayList<LeafReaderContext>(segments);
            try {
                copy.sort(this);
            }
            catch (RuntimeException e) {
                if (COMPARISON_ERROR_MESSAGE.equals(e.getMessage())) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
            return copy;
        }

        private long getTermsSize(LeafReaderContext leafReaderContext) throws IOException {
            Terms terms = leafReaderContext.reader().terms(PhraseWildcardQuery.this.field);
            return terms == null ? 0L : terms.size();
        }
    }

    protected static class TermsData {
        protected final int numTerms;
        protected final int numSegments;
        protected final List<TermStatistics> termStatsList;
        protected final TermData[] termDataPerPosition;
        protected int numTermsMatching;

        protected TermsData(int numTerms, int numSegments) {
            this.numTerms = numTerms;
            this.numSegments = numSegments;
            this.termStatsList = new ArrayList<TermStatistics>();
            this.termDataPerPosition = new TermData[numTerms];
        }

        protected TermData getOrCreateTermData(int termPosition) {
            TermData termData = this.termDataPerPosition[termPosition];
            if (termData == null) {
                this.termDataPerPosition[termPosition] = termData = new TermData(this.numSegments, this);
            }
            return termData;
        }

        protected TermData getTermData(int termPosition) {
            return this.termDataPerPosition[termPosition];
        }

        protected boolean areAllTermsMatching() {
            assert (this.numTermsMatching <= this.numTerms);
            return this.numTermsMatching == this.numTerms;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TermsData(");
            builder.append("numSegments=").append(this.numSegments);
            builder.append(", termDataPerPosition=").append(Arrays.asList(this.termDataPerPosition));
            builder.append(", termsStatsList=[");
            for (TermStatistics termStatistics : this.termStatsList) {
                builder.append("{").append(termStatistics.term().utf8ToString()).append(", ").append(termStatistics.docFreq()).append(", ").append(termStatistics.totalTermFreq()).append("}");
            }
            builder.append("]");
            builder.append(")");
            return builder.toString();
        }
    }

    protected static class TestCounters {
        private static final TestCounters SINGLETON = new TestCounters();
        protected long singleTermAnalysisCount;
        protected long multiTermAnalysisCount;
        protected long expansionCount;
        protected long segmentUseCount;
        protected long segmentSkipCount;
        protected long queryEarlyStopCount;

        protected TestCounters() {
        }

        protected static TestCounters get() {
            return SINGLETON;
        }

        protected boolean incSingleTermAnalysisCount() {
            ++this.singleTermAnalysisCount;
            return true;
        }

        protected boolean incMultiTermAnalysisCount() {
            ++this.multiTermAnalysisCount;
            return true;
        }

        protected boolean incExpansionCount() {
            ++this.expansionCount;
            return true;
        }

        protected boolean incSegmentUseCount() {
            ++this.segmentUseCount;
            return true;
        }

        protected boolean incSegmentSkipCount() {
            ++this.segmentSkipCount;
            return true;
        }

        protected boolean incQueryEarlyStopCount() {
            ++this.queryEarlyStopCount;
            return true;
        }

        protected void clear() {
            this.singleTermAnalysisCount = 0L;
            this.multiTermAnalysisCount = 0L;
            this.expansionCount = 0L;
            this.segmentUseCount = 0L;
            this.segmentSkipCount = 0L;
            this.queryEarlyStopCount = 0L;
        }
    }

    protected static class SingleTerm
    extends PhraseTerm {
        protected final Term term;

        protected SingleTerm(Term term, int termPosition) {
            super(termPosition);
            this.term = term;
        }

        @Override
        protected boolean hasExpansions() {
            return false;
        }

        @Override
        protected Query getQuery() {
            return new TermQuery(this.term);
        }

        @Override
        protected int collectTermData(PhraseWildcardQuery query, IndexSearcher searcher, List<LeafReaderContext> segments, TermsData termsData) throws IOException {
            return this.collectTermData(query, searcher, segments, 0, 0, termsData);
        }

        @Override
        protected int collectTermData(PhraseWildcardQuery query, IndexSearcher searcher, List<LeafReaderContext> segments, int remainingMultiTerms, int maxExpansionsForTerm, TermsData termsData) throws IOException {
            return query.collectSingleTermData(this, searcher, segments, termsData);
        }

        @Override
        protected void toString(StringBuilder builder) {
            builder.append(this.term.text());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SingleTerm)) {
                return false;
            }
            SingleTerm singleTerm = (SingleTerm)o;
            return this.term.equals((Object)singleTerm.term);
        }

        @Override
        public int hashCode() {
            return this.term.hashCode();
        }
    }

    protected static class TermData {
        protected final int numSegments;
        protected final TermsData termsData;
        protected List<TermBytesTermState>[] termStatesPerSegment;
        protected final List<Term> terms;

        protected TermData(int numSegments, TermsData termsData) {
            this.numSegments = numSegments;
            this.termsData = termsData;
            this.terms = new ArrayList<Term>();
        }

        protected void setTermStatesForSegment(LeafReaderContext leafReaderContext, List<TermBytesTermState> termStates) {
            if (this.termStatesPerSegment == null) {
                this.termStatesPerSegment = new List[this.numSegments];
                ++this.termsData.numTermsMatching;
            }
            this.termStatesPerSegment[leafReaderContext.ord] = termStates;
        }

        protected List<TermBytesTermState> getTermStatesForSegment(LeafReaderContext leafReaderContext) {
            assert (this.termStatesPerSegment != null) : "No TermState for any segment; the query should have been stopped before";
            return this.termStatesPerSegment[leafReaderContext.ord];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TermData(");
            builder.append("termStates=");
            if (this.termStatesPerSegment == null) {
                builder.append("null");
            } else {
                builder.append(Arrays.asList(this.termStatesPerSegment));
            }
            builder.append(", terms=").append(this.terms);
            builder.append(")");
            return builder.toString();
        }
    }

    public static class TermBytesTermState {
        protected final BytesRef termBytes;
        protected final TermState termState;

        public TermBytesTermState(BytesRef termBytes, TermState termState) {
            this.termBytes = termBytes;
            this.termState = termState;
        }

        public String toString() {
            return "\"" + this.termBytes.utf8ToString() + "\"->" + this.termState;
        }
    }

    protected static class MultiTerm
    extends PhraseTerm {
        protected final MultiTermQuery query;

        protected MultiTerm(MultiTermQuery query, int termPosition) {
            super(termPosition);
            this.query = query;
        }

        @Override
        protected boolean hasExpansions() {
            return true;
        }

        @Override
        protected Query getQuery() {
            return this.query;
        }

        @Override
        protected int collectTermData(PhraseWildcardQuery query, IndexSearcher searcher, List<LeafReaderContext> segments, int remainingMultiTerms, int maxExpansionsForTerm, TermsData termsData) throws IOException {
            return query.collectMultiTermData(this, searcher, segments, remainingMultiTerms, maxExpansionsForTerm, termsData);
        }

        @Override
        protected void toString(StringBuilder builder) {
            builder.append(this.query.toString(this.query.getField()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MultiTerm)) {
                return false;
            }
            MultiTerm multiTerm = (MultiTerm)o;
            return this.query.equals((Object)multiTerm.query);
        }

        @Override
        public int hashCode() {
            return this.query.hashCode();
        }
    }

    public static class TermStats {
        protected final BytesRef termBytes;
        protected int docFreq;
        protected long totalTermFreq;

        protected TermStats(BytesRef termBytes) {
            this.termBytes = termBytes;
        }

        public BytesRef getTermBytes() {
            return this.termBytes;
        }

        protected void addStats(int docFreq, long totalTermFreq) {
            this.docFreq += docFreq;
            this.totalTermFreq = this.totalTermFreq >= 0L && totalTermFreq >= 0L ? (this.totalTermFreq += totalTermFreq) : -1L;
        }
    }

    public static class Builder {
        protected final String field;
        protected final List<PhraseTerm> phraseTerms;
        protected int slop;
        protected final int maxMultiTermExpansions;
        protected final boolean segmentOptimizationEnabled;

        public Builder(String field, int maxMultiTermExpansions) {
            this(field, maxMultiTermExpansions, true);
        }

        public Builder(String field, int maxMultiTermExpansions, boolean segmentOptimizationEnabled) {
            this.field = field;
            this.maxMultiTermExpansions = maxMultiTermExpansions;
            this.segmentOptimizationEnabled = segmentOptimizationEnabled;
            this.phraseTerms = new ArrayList<PhraseTerm>();
        }

        public Builder addTerm(BytesRef termBytes) {
            return this.addTerm(new Term(this.field, termBytes));
        }

        public Builder addTerm(Term term) {
            if (!term.field().equals(this.field)) {
                throw new IllegalArgumentException(term.getClass().getSimpleName() + " field \"" + term.field() + "\" cannot be different from the " + PhraseWildcardQuery.class.getSimpleName() + " field \"" + this.field + "\"");
            }
            this.phraseTerms.add(new SingleTerm(term, this.phraseTerms.size()));
            return this;
        }

        public Builder addMultiTerm(MultiTermQuery multiTermQuery) {
            if (!multiTermQuery.getField().equals(this.field)) {
                throw new IllegalArgumentException(multiTermQuery.getClass().getSimpleName() + " field \"" + multiTermQuery.getField() + "\" cannot be different from the " + PhraseWildcardQuery.class.getSimpleName() + " field \"" + this.field + "\"");
            }
            this.phraseTerms.add(new MultiTerm(multiTermQuery, this.phraseTerms.size()));
            return this;
        }

        public Builder setSlop(int slop) {
            if (slop < 0) {
                throw new IllegalArgumentException("slop value cannot be negative");
            }
            this.slop = slop;
            return this;
        }

        public PhraseWildcardQuery build() {
            return new PhraseWildcardQuery(this.field, this.phraseTerms, this.slop, this.maxMultiTermExpansions, this.segmentOptimizationEnabled);
        }
    }
}

