/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPResultWriter;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.util.Base64;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.io.OutputStream;
import java.util.ArrayList;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class JSONLDAPResultWriter
extends LDAPResultWriter {
    @NotNull
    private final ArrayList<String> formattedLines = new ArrayList(10);
    @NotNull
    private final JSONBuffer jsonBuffer = new JSONBuffer(null, 0, true);

    public JSONLDAPResultWriter(@NotNull OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void writeComment(@NotNull String comment) {
    }

    @Override
    public void writeHeader() {
    }

    @Override
    public void writeSearchResultEntry(@NotNull SearchResultEntry entry) {
        this.jsonBuffer.clear();
        this.jsonBuffer.beginObject();
        this.jsonBuffer.appendString("result-type", "entry");
        this.jsonBuffer.appendString("dn", entry.getDN());
        this.jsonBuffer.beginArray("attributes");
        for (Attribute a : entry.getAttributes()) {
            this.jsonBuffer.beginObject();
            this.jsonBuffer.appendString("name", a.getName());
            this.jsonBuffer.beginArray("values");
            for (String value : a.getValues()) {
                this.jsonBuffer.appendString(value);
            }
            this.jsonBuffer.endArray();
            this.jsonBuffer.endObject();
        }
        this.jsonBuffer.endArray();
        this.handleControls(entry.getControls());
        this.jsonBuffer.endObject();
        this.println(this.jsonBuffer.toString());
    }

    @Override
    public void writeSearchResultReference(@NotNull SearchResultReference ref) {
        this.jsonBuffer.clear();
        this.jsonBuffer.beginObject();
        this.jsonBuffer.appendString("result-type", "reference");
        this.jsonBuffer.beginArray("referral-urls");
        for (String url : ref.getReferralURLs()) {
            this.jsonBuffer.appendString(url);
        }
        this.jsonBuffer.endArray();
        this.handleControls(ref.getControls());
        this.jsonBuffer.endObject();
        this.println(this.jsonBuffer.toString());
    }

    @Override
    public void writeResult(@NotNull LDAPResult result) {
        String[] referralURLs;
        String matchedDN;
        this.jsonBuffer.clear();
        this.jsonBuffer.beginObject();
        if (result instanceof SearchResult) {
            this.jsonBuffer.appendString("result-type", "search-result");
        } else {
            this.jsonBuffer.appendString("result-type", "ldap-result");
        }
        this.jsonBuffer.appendNumber("result-code", result.getResultCode().intValue());
        this.jsonBuffer.appendString("result-code-name", result.getResultCode().getName());
        String diagnosticMessage = result.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            this.jsonBuffer.appendString("diagnostic-message", diagnosticMessage);
        }
        if ((matchedDN = result.getMatchedDN()) != null) {
            this.jsonBuffer.appendString("matched-dn", matchedDN);
        }
        if ((referralURLs = result.getReferralURLs()) != null && referralURLs.length > 0) {
            this.jsonBuffer.beginArray("referral-urls");
            for (String url : referralURLs) {
                this.jsonBuffer.appendString(url);
            }
            this.jsonBuffer.endArray();
        }
        if (result instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)result;
            this.jsonBuffer.appendNumber("entries-returned", searchResult.getEntryCount());
            this.jsonBuffer.appendNumber("references-returned", searchResult.getReferenceCount());
        }
        this.handleControls(result.getResponseControls());
        this.jsonBuffer.endObject();
        this.println(this.jsonBuffer.toString());
    }

    @Override
    public void writeUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        String[] referralURLs;
        String matchedDN;
        this.jsonBuffer.clear();
        this.jsonBuffer.beginObject();
        this.jsonBuffer.appendString("result-type", "unsolicited-notification");
        String oid = notification.getOID();
        if (oid != null) {
            this.jsonBuffer.appendString("oid", oid);
        }
        if (notification.hasValue()) {
            this.jsonBuffer.appendString("base64-encoded-value", Base64.encode(notification.getValue().getValue()));
        }
        this.jsonBuffer.appendNumber("result-code", notification.getResultCode().intValue());
        this.jsonBuffer.appendString("result-code-name", notification.getResultCode().getName());
        String diagnosticMessage = notification.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            this.jsonBuffer.appendString("diagnostic-message", diagnosticMessage);
        }
        if ((matchedDN = notification.getMatchedDN()) != null) {
            this.jsonBuffer.appendString("matched-dn", matchedDN);
        }
        if ((referralURLs = notification.getReferralURLs()) != null && referralURLs.length > 0) {
            this.jsonBuffer.beginArray("referral-urls");
            for (String url : referralURLs) {
                this.jsonBuffer.appendString(url);
            }
            this.jsonBuffer.endArray();
        }
        this.handleControls(notification.getResponseControls());
        this.formattedLines.clear();
        ResultUtils.formatUnsolicitedNotification(this.formattedLines, notification, false, 0, Integer.MAX_VALUE);
        this.jsonBuffer.beginArray("formatted-unsolicited-notification-lines");
        for (String line : this.formattedLines) {
            this.jsonBuffer.appendString(line.trim());
        }
        this.jsonBuffer.endArray();
        this.jsonBuffer.endObject();
        this.println(this.jsonBuffer.toString());
    }

    private void handleControls(@Nullable Control[] controls) {
        if (controls == null || controls.length == 0) {
            return;
        }
        this.jsonBuffer.beginArray("controls");
        for (Control c : controls) {
            this.jsonBuffer.beginObject();
            this.jsonBuffer.appendString("oid", c.getOID());
            this.jsonBuffer.appendBoolean("criticality", c.isCritical());
            if (c.hasValue()) {
                this.jsonBuffer.appendString("base64-encoded-value", Base64.encode(c.getValue().getValue()));
            }
            this.formattedLines.clear();
            ResultUtils.formatResponseControl(this.formattedLines, c, false, 0, Integer.MAX_VALUE);
            this.jsonBuffer.beginArray("formatted-control-lines");
            for (String line : this.formattedLines) {
                this.jsonBuffer.appendString(line.trim());
            }
            this.jsonBuffer.endArray();
            this.jsonBuffer.endObject();
        }
        this.jsonBuffer.endArray();
    }
}

