/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j2;

import co.elastic.logging.EcsJsonSerializer;
import co.elastic.logging.JsonUtils;
import co.elastic.logging.log4j2.ObjectMessageJacksonSerializer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.TriConsumer;

@Plugin(name="EcsLayout", category="Core", elementType="layout")
public class EcsLayout
extends AbstractStringLayout {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String[] JSON_FORMAT = new String[]{"JSON"};
    private final TriConsumer<String, Object, StringBuilder> WRITE_KEY_VALUES_INTO = new TriConsumer<String, Object, StringBuilder>(){

        public void accept(String key, Object value, StringBuilder stringBuilder) {
            stringBuilder.append('\"');
            if (!EcsLayout.this.topLevelLabels.contains(key)) {
                stringBuilder.append("labels.");
            }
            JsonUtils.quoteAsString((CharSequence)key, (StringBuilder)stringBuilder);
            stringBuilder.append("\":\"");
            JsonUtils.quoteAsString((CharSequence)EcsJsonSerializer.toNullSafeString((CharSequence)String.valueOf(value)), (StringBuilder)stringBuilder);
            stringBuilder.append("\",");
        }
    };
    private final KeyValuePair[] additionalFields;
    private final PatternFormatter[][] fieldValuePatternFormatter;
    private final Set<String> topLevelLabels;
    private final boolean stackTraceAsArray;
    private final String serviceName;
    private final boolean includeMarkers;
    private final boolean includeOrigin;
    private final ConcurrentMap<Class<? extends MultiformatMessage>, Boolean> supportsJson = new ConcurrentHashMap<Class<? extends MultiformatMessage>, Boolean>();
    private final ObjectMessageJacksonSerializer objectMessageJacksonSerializer = ObjectMessageJacksonSerializer.Resolver.INSTANCE.resolve();

    private EcsLayout(Configuration config, String serviceName, boolean includeMarkers, KeyValuePair[] additionalFields, Collection<String> topLevelLabels, boolean includeOrigin, boolean stackTraceAsArray) {
        super(config, UTF_8, null, null);
        this.serviceName = serviceName;
        this.includeMarkers = includeMarkers;
        this.topLevelLabels = new HashSet<String>(topLevelLabels);
        this.topLevelLabels.addAll(EcsJsonSerializer.DEFAULT_TOP_LEVEL_LABELS);
        this.includeOrigin = includeOrigin;
        this.stackTraceAsArray = stackTraceAsArray;
        this.additionalFields = additionalFields;
        this.fieldValuePatternFormatter = new PatternFormatter[additionalFields.length][];
        for (int i = 0; i < additionalFields.length; ++i) {
            KeyValuePair additionalField = additionalFields[i];
            if (!additionalField.getValue().contains("%")) continue;
            this.fieldValuePatternFormatter[i] = PatternLayout.createPatternParser((Configuration)config).parse(additionalField.getValue()).toArray(new PatternFormatter[0]);
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return (Builder)new Builder().asBuilder();
    }

    private static boolean valueNeedsLookup(String value) {
        return value != null && value.contains("${");
    }

    public String toSerializable(LogEvent event) {
        StringBuilder text = this.toText(event, EcsLayout.getStringBuilder(), false);
        return text.toString();
    }

    public void encode(LogEvent event, ByteBufferDestination destination) {
        StringBuilder text = this.toText(event, EcsLayout.getStringBuilder(), true);
        Encoder helper = this.getStringBuilderEncoder();
        helper.encode((Object)text, destination);
    }

    private StringBuilder toText(LogEvent event, StringBuilder builder, boolean gcFree) {
        EcsJsonSerializer.serializeObjectStart((StringBuilder)builder, (long)event.getTimeMillis());
        EcsJsonSerializer.serializeLogLevel((StringBuilder)builder, (String)event.getLevel().toString());
        this.serializeMessage(builder, gcFree, event.getMessage(), event.getThrown());
        EcsJsonSerializer.serializeServiceName((StringBuilder)builder, (String)this.serviceName);
        EcsJsonSerializer.serializeThreadName((StringBuilder)builder, (String)event.getThreadName());
        EcsJsonSerializer.serializeLoggerName((StringBuilder)builder, (String)event.getLoggerName());
        this.serializeLabels(event, builder);
        this.serializeTags(event, builder);
        if (this.includeOrigin) {
            EcsJsonSerializer.serializeOrigin((StringBuilder)builder, (StackTraceElement)event.getSource());
        }
        EcsJsonSerializer.serializeException((StringBuilder)builder, (Throwable)event.getThrown(), (boolean)this.stackTraceAsArray);
        EcsJsonSerializer.serializeObjectEnd((StringBuilder)builder);
        return builder;
    }

    private void serializeLabels(LogEvent event, StringBuilder builder) {
        int length = this.additionalFields.length;
        if (!event.getContextData().isEmpty() || length > 0) {
            if (length > 0) {
                StrSubstitutor strSubstitutor = this.getConfiguration().getStrSubstitutor();
                for (int i = 0; i < length; ++i) {
                    KeyValuePair additionalField = this.additionalFields[i];
                    PatternFormatter[] formatters = this.fieldValuePatternFormatter[i];
                    CharSequence value = null;
                    if (formatters != null) {
                        StringBuilder buffer = EcsJsonSerializer.getMessageStringBuilder();
                        EcsLayout.formatPattern(event, formatters, buffer);
                        if (buffer.length() > 0) {
                            value = buffer;
                        }
                    } else if (EcsLayout.valueNeedsLookup(additionalField.getValue())) {
                        StringBuilder lookupValue = EcsJsonSerializer.getMessageStringBuilder();
                        lookupValue.append(additionalField.getValue());
                        if (strSubstitutor.replaceIn(event, lookupValue)) {
                            value = lookupValue;
                        }
                    } else {
                        value = additionalField.getValue();
                    }
                    if (value == null) continue;
                    builder.append('\"');
                    JsonUtils.quoteAsString((CharSequence)additionalField.getKey(), (StringBuilder)builder);
                    builder.append("\":\"");
                    JsonUtils.quoteAsString((CharSequence)EcsJsonSerializer.toNullSafeString((CharSequence)value), (StringBuilder)builder);
                    builder.append("\",");
                }
            }
            event.getContextData().forEach(this.WRITE_KEY_VALUES_INTO, (Object)builder);
        }
    }

    private static void formatPattern(LogEvent event, PatternFormatter[] formatters, StringBuilder buffer) {
        int len = formatters.length;
        for (int i = 0; i < len; ++i) {
            formatters[i].format(event, buffer);
        }
    }

    private void serializeTags(LogEvent event, StringBuilder builder) {
        boolean hasTags;
        List contextStack = event.getContextStack().asList();
        Marker marker = event.getMarker();
        boolean bl = hasTags = !contextStack.isEmpty() || this.includeMarkers && marker != null;
        if (hasTags) {
            EcsJsonSerializer.serializeTagStart((StringBuilder)builder);
        }
        if (!contextStack.isEmpty()) {
            int len = contextStack.size();
            for (int i = 0; i < len; ++i) {
                builder.append('\"');
                JsonUtils.quoteAsString((CharSequence)((CharSequence)contextStack.get(i)), (StringBuilder)builder);
                builder.append("\",");
            }
        }
        if (this.includeMarkers && marker != null) {
            this.serializeMarker(builder, marker);
        }
        if (hasTags) {
            EcsJsonSerializer.serializeTagEnd((StringBuilder)builder);
        }
    }

    private void serializeMarker(StringBuilder builder, Marker marker) {
        EcsJsonSerializer.serializeSingleTag((StringBuilder)builder, (String)marker.getName());
        if (marker.hasParents()) {
            Marker[] parents = marker.getParents();
            for (int i = 0; i < parents.length; ++i) {
                this.serializeMarker(builder, parents[i]);
            }
        }
    }

    private void serializeMessage(StringBuilder builder, boolean gcFree, Message message, Throwable thrown) {
        if (message instanceof MultiformatMessage) {
            MultiformatMessage multiformatMessage = (MultiformatMessage)message;
            if (this.supportsJson(multiformatMessage)) {
                EcsLayout.serializeJsonMessage(builder, multiformatMessage);
            } else {
                this.serializeSimpleMessage(builder, gcFree, message, thrown);
            }
        } else if (this.objectMessageJacksonSerializer != null && message instanceof ObjectMessage) {
            StringBuilder jsonBuffer = EcsJsonSerializer.getMessageStringBuilder();
            this.objectMessageJacksonSerializer.formatTo(jsonBuffer, (ObjectMessage)message);
            EcsLayout.addJson(builder, jsonBuffer);
        } else {
            this.serializeSimpleMessage(builder, gcFree, message, thrown);
        }
    }

    private static void serializeJsonMessage(StringBuilder builder, MultiformatMessage message) {
        StringBuilder messageBuffer = EcsJsonSerializer.getMessageStringBuilder();
        if (message instanceof MultiFormatStringBuilderFormattable) {
            ((MultiFormatStringBuilderFormattable)message).formatTo(JSON_FORMAT, messageBuffer);
        } else {
            messageBuffer.append(message.getFormattedMessage(JSON_FORMAT));
        }
        EcsLayout.addJson(builder, messageBuffer);
    }

    private static void addJson(StringBuilder buffer, StringBuilder jsonBuffer) {
        if (EcsLayout.isObject(jsonBuffer)) {
            EcsLayout.moveToRoot(jsonBuffer);
            buffer.append((CharSequence)jsonBuffer);
            buffer.append(", ");
        } else {
            buffer.append("\"message\":");
            if (EcsLayout.isString(jsonBuffer)) {
                buffer.append((CharSequence)jsonBuffer);
            } else {
                buffer.append('\"');
                JsonUtils.quoteAsString((CharSequence)jsonBuffer, (StringBuilder)buffer);
                buffer.append('\"');
            }
            buffer.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeSimpleMessage(StringBuilder builder, boolean gcFree, Message message, Throwable thrown) {
        builder.append("\"message\":\"");
        if (message instanceof CharSequence) {
            JsonUtils.quoteAsString((CharSequence)((CharSequence)message), (StringBuilder)builder);
        } else if (gcFree && message instanceof StringBuilderFormattable) {
            StringBuilder messageBuffer = EcsJsonSerializer.getMessageStringBuilder();
            try {
                ((StringBuilderFormattable)message).formatTo(messageBuffer);
                JsonUtils.quoteAsString((CharSequence)messageBuffer, (StringBuilder)builder);
            }
            finally {
                EcsLayout.trimToMaxSize((StringBuilder)messageBuffer);
            }
        } else {
            JsonUtils.quoteAsString((CharSequence)EcsJsonSerializer.toNullSafeString((CharSequence)message.getFormattedMessage()), (StringBuilder)builder);
        }
        builder.append("\", ");
    }

    private static boolean isObject(StringBuilder messageBuffer) {
        return messageBuffer.length() > 1 && messageBuffer.charAt(0) == '{' && messageBuffer.charAt(messageBuffer.length() - 1) == '}';
    }

    private static boolean isString(StringBuilder messageBuffer) {
        return messageBuffer.length() > 1 && messageBuffer.charAt(0) == '\"' && messageBuffer.charAt(messageBuffer.length() - 1) == '\"';
    }

    private static void moveToRoot(StringBuilder messageBuffer) {
        messageBuffer.setCharAt(0, ' ');
        messageBuffer.setCharAt(messageBuffer.length() - 1, ' ');
    }

    private boolean supportsJson(MultiformatMessage message) {
        Boolean supportsJson = (Boolean)this.supportsJson.get(message.getClass());
        if (supportsJson == null) {
            supportsJson = false;
            for (String format : message.getFormats()) {
                if (!format.equalsIgnoreCase("JSON")) continue;
                supportsJson = true;
                break;
            }
            this.supportsJson.put(message.getClass(), supportsJson);
        }
        return supportsJson;
    }

    public static class Builder
    extends AbstractStringLayout.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<EcsLayout> {
        @PluginBuilderAttribute(value="serviceName")
        private String serviceName;
        @PluginBuilderAttribute(value="includeMarkers")
        private boolean includeMarkers = false;
        @PluginBuilderAttribute(value="stackTraceAsArray")
        private boolean stackTraceAsArray = false;
        @PluginElement(value="AdditionalField")
        private KeyValuePair[] additionalFields = new KeyValuePair[0];
        @PluginBuilderAttribute(value="topLevelLabels")
        private String topLevelLabels;
        @PluginBuilderAttribute(value="includeOrigin")
        private boolean includeOrigin = false;

        Builder() {
            this.setCharset(UTF_8);
        }

        public KeyValuePair[] getAdditionalFields() {
            return this.additionalFields;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public boolean isIncludeMarkers() {
            return this.includeMarkers;
        }

        public boolean isIncludeOrigin() {
            return this.includeOrigin;
        }

        public String getTopLevelLabels() {
            return this.topLevelLabels;
        }

        public Builder setTopLevelLabels(String topLevelLabels) {
            this.topLevelLabels = topLevelLabels;
            return (Builder)this.asBuilder();
        }

        public Builder setAdditionalFields(KeyValuePair[] additionalFields) {
            this.additionalFields = additionalFields;
            return (Builder)this.asBuilder();
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return (Builder)this.asBuilder();
        }

        public Builder setIncludeMarkers(boolean includeMarkers) {
            this.includeMarkers = includeMarkers;
            return (Builder)this.asBuilder();
        }

        public Builder setIncludeOrigin(boolean includeOrigin) {
            this.includeOrigin = includeOrigin;
            return (Builder)this.asBuilder();
        }

        public Builder setStackTraceAsArray(boolean stackTraceAsArray) {
            this.stackTraceAsArray = stackTraceAsArray;
            return (Builder)this.asBuilder();
        }

        public EcsLayout build() {
            ArrayList<String> topLevelLabelsList = new ArrayList<String>();
            if (this.topLevelLabels != null) {
                for (String label : this.topLevelLabels.split(",")) {
                    topLevelLabelsList.add(label.trim());
                }
            }
            return new EcsLayout(this.getConfiguration(), this.serviceName, this.includeMarkers, this.additionalFields, topLevelLabelsList, this.includeOrigin, this.stackTraceAsArray);
        }

        public boolean isStackTraceAsArray() {
            return this.stackTraceAsArray;
        }
    }
}

