/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;

public class ReflectionUtils {
    public static <E> Class<E> detectSuperTypeForRuleLike(Class<?> c) {
        Class<?> clazz;
        Type type = clazz.getGenericSuperclass();
        for (clazz = c; clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (type instanceof ParameterizedType) {
                Type rawType;
                Object[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
                if (typeArguments.length != 2 && typeArguments.length != 1) {
                    throw new QlIllegalArgumentException("Unexpected number of type arguments {} for {}", Arrays.toString(typeArguments), c);
                }
                Type tp = typeArguments[0];
                if (tp instanceof Class) {
                    return (Class)tp;
                }
                if (tp instanceof ParameterizedType && (rawType = ((ParameterizedType)tp).getRawType()) instanceof Class) {
                    return (Class)rawType;
                }
                throw new QlIllegalArgumentException("Unexpected class structure for class {}", c);
            }
            type = clazz.getGenericSuperclass();
        }
        throw new QlIllegalArgumentException("Unexpected class structure for class {}", c);
    }

    public static String ruleLikeNaming(Class<?> c) {
        String className = c.getName();
        int parentPackage = className.lastIndexOf(".");
        if (parentPackage > 0) {
            int grandParentPackage = className.substring(0, parentPackage).lastIndexOf(".");
            return grandParentPackage > 0 ? className.substring(grandParentPackage + 1) : className.substring(parentPackage);
        }
        return className;
    }
}

