/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.cli;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import joptsimple.OptionSet;
import org.elasticsearch.Version;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.env.Environment;
import org.elasticsearch.plugins.PluginInfo;

class ListPluginsCommand
extends EnvironmentAwareCommand {
    ListPluginsCommand() {
        super("Lists installed elasticsearch plugins");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!Files.exists(env.pluginsFile(), new LinkOption[0])) {
            throw new IOException("Plugins directory missing: " + env.pluginsFile());
        }
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Plugins directory: " + env.pluginsFile()));
        ArrayList<Path> plugins = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(env.pluginsFile());){
            for (Path plugin : paths) {
                plugins.add(plugin);
            }
        }
        Collections.sort(plugins);
        for (Path plugin : plugins) {
            this.printPlugin(env, terminal, plugin, "");
        }
    }

    private void printPlugin(Environment env, Terminal terminal, Path plugin, String prefix) throws IOException {
        terminal.println(Terminal.Verbosity.SILENT, (CharSequence)(prefix + plugin.getFileName().toString()));
        PluginInfo info = PluginInfo.readFromProperties((Path)env.pluginsFile().resolve(plugin));
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)info.toString(prefix));
        if (!info.getElasticsearchVersion().equals((Object)Version.CURRENT)) {
            terminal.errorPrintln("WARNING: plugin [" + info.getName() + "] was built for Elasticsearch version " + info.getElasticsearchVersion() + " but version " + Version.CURRENT + " is required");
        }
    }
}

