/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.vectors.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class KnnVectorFieldExistsQuery
extends Query {
    private final String field;

    public KnnVectorFieldExistsQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    public String getField() {
        return this.field;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((KnnVectorFieldExistsQuery)((Object)other)).field);
    }

    public int hashCode() {
        return 31 * this.classHash() + this.field.hashCode();
    }

    public String toString(String field) {
        return "KnnVectorFieldExistsQuery [field=" + this.field + "]";
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                VectorValues iterator = context.reader().getVectorValues(KnnVectorFieldExistsQuery.this.field);
                if (iterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, (DocIdSetIterator)iterator);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }
}

