/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.ByteTrackingSortingNumericDocValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;

class GeoShapeCellValues
extends ByteTrackingSortingNumericDocValues {
    private final GeoShapeValues geoShapeValues;
    protected final GeoGridTiler tiler;

    protected GeoShapeCellValues(GeoShapeValues geoShapeValues, GeoGridTiler tiler, LongConsumer circuitBreakerConsumer) {
        super(circuitBreakerConsumer);
        this.geoShapeValues = geoShapeValues;
        this.tiler = tiler;
    }

    public boolean advanceExact(int docId) throws IOException {
        if (this.geoShapeValues.advanceExact(docId)) {
            int j = this.tiler.setValues(this, this.geoShapeValues.value());
            this.resize(j);
            this.sort();
            return true;
        }
        return false;
    }

    protected long[] getValues() {
        return this.values;
    }

    void resizeCell(int newSize) {
        this.resize(newSize);
    }

    protected void add(int idx, long value) {
        this.values[idx] = value;
    }
}

