/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.intervals.ConjunctionMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalIterator;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

class RepeatingIntervalsSource
extends IntervalsSource {
    final IntervalsSource in;
    final int childCount;
    String name;

    static IntervalsSource build(IntervalsSource in, int childCount) {
        if (childCount == 1) {
            return in;
        }
        assert (childCount > 0);
        return new RepeatingIntervalsSource(in, childCount);
    }

    private RepeatingIntervalsSource(IntervalsSource in, int childCount) {
        this.in = in;
        this.childCount = childCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        IntervalIterator it = this.in.intervals(field, ctx);
        if (it == null) {
            return null;
        }
        return new DuplicateIntervalIterator(it, this.childCount);
    }

    @Override
    public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<IntervalMatchesIterator> subs = new ArrayList<IntervalMatchesIterator>();
        for (int i = 0; i < this.childCount; ++i) {
            IntervalMatchesIterator mi = this.in.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(mi);
        }
        return DuplicateMatchesIterator.build(subs);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        this.in.visit(field, visitor);
    }

    @Override
    public int minExtent() {
        return this.in.minExtent();
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singleton(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.childCount);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof RepeatingIntervalsSource)) {
            return false;
        }
        RepeatingIntervalsSource o = (RepeatingIntervalsSource)other;
        return Objects.equals(this.in, o.in) && Objects.equals(this.childCount, o.childCount);
    }

    @Override
    public String toString() {
        String s = this.in.toString();
        StringBuilder out = new StringBuilder(s);
        for (int i = 1; i < this.childCount; ++i) {
            out.append(",").append(s);
        }
        if (this.name != null) {
            return this.name + "(" + out.toString() + ")";
        }
        return out.toString();
    }

    private static class DuplicateIntervalIterator
    extends IntervalIterator {
        private final IntervalIterator in;
        final int[] cache;
        final int cacheLength;
        int cacheBase;
        boolean started = false;
        boolean exhausted = false;

        private DuplicateIntervalIterator(IntervalIterator primary, int copies) {
            this.in = primary;
            this.cacheLength = copies;
            this.cache = new int[this.cacheLength * 2];
        }

        @Override
        public int start() {
            return this.exhausted ? Integer.MAX_VALUE : this.cache[this.cacheBase % this.cacheLength * 2];
        }

        @Override
        public int end() {
            return this.exhausted ? Integer.MAX_VALUE : this.cache[(this.cacheBase + this.cacheLength - 1) % this.cacheLength * 2 + 1];
        }

        @Override
        public int width() {
            int width = 0;
            for (int i = 0; i < this.cacheLength; ++i) {
                int pos = (this.cacheBase + i) % this.cacheLength;
                width += this.cache[pos * 2] - this.cache[pos * 2 + 1] + 1;
            }
            return width;
        }

        @Override
        public int gaps() {
            return super.width() - this.width();
        }

        @Override
        public int nextInterval() throws IOException {
            if (this.exhausted) {
                return Integer.MAX_VALUE;
            }
            if (!this.started) {
                for (int i = 0; i < this.cacheLength; ++i) {
                    if (this.cacheNextInterval(i) != Integer.MAX_VALUE) continue;
                    return Integer.MAX_VALUE;
                }
                this.cacheBase = 0;
                this.started = true;
                return this.start();
            }
            int insert = (this.cacheBase + this.cacheLength) % this.cacheLength;
            this.cacheBase = (this.cacheBase + 1) % this.cacheLength;
            return this.cacheNextInterval(insert);
        }

        private int cacheNextInterval(int linePos) throws IOException {
            if (this.in.nextInterval() == Integer.MAX_VALUE) {
                this.exhausted = true;
                return Integer.MAX_VALUE;
            }
            this.cache[linePos * 2] = this.in.start();
            this.cache[linePos * 2 + 1] = this.in.end();
            return this.start();
        }

        @Override
        public float matchCost() {
            return this.in.matchCost();
        }

        public int docID() {
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            this.exhausted = false;
            this.started = false;
            Arrays.fill(this.cache, -1);
            return this.in.nextDoc();
        }

        public int advance(int target) throws IOException {
            this.exhausted = false;
            this.started = false;
            Arrays.fill(this.cache, -1);
            return this.in.advance(target);
        }

        public long cost() {
            return this.in.cost();
        }
    }

    private static class DuplicateMatchesIterator
    implements IntervalMatchesIterator {
        List<IntervalMatchesIterator> subs;
        boolean cached = false;

        static IntervalMatchesIterator build(List<IntervalMatchesIterator> subs) throws IOException {
            for (int count = subs.size(); count > 0; --count) {
                for (int i = 0; i < count; ++i) {
                    if (subs.get(count - 1).next()) continue;
                    return null;
                }
            }
            return new DuplicateMatchesIterator(subs);
        }

        private DuplicateMatchesIterator(List<IntervalMatchesIterator> subs) throws IOException {
            this.subs = subs;
        }

        public boolean next() throws IOException {
            if (!this.cached) {
                this.cached = true;
                return true;
            }
            if (!this.subs.get(this.subs.size() - 1).next()) {
                return false;
            }
            for (int i = 0; i < this.subs.size() - 1; ++i) {
                this.subs.get(i).next();
            }
            return true;
        }

        public int startPosition() {
            return this.subs.get(0).startPosition();
        }

        public int endPosition() {
            return this.subs.get(this.subs.size() - 1).endPosition();
        }

        public int startOffset() throws IOException {
            return this.subs.get(0).startOffset();
        }

        public int endOffset() throws IOException {
            return this.subs.get(this.subs.size() - 1).endOffset();
        }

        public MatchesIterator getSubMatches() throws IOException {
            ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
            for (MatchesIterator matchesIterator : this.subs) {
                Object sub = matchesIterator.getSubMatches();
                if (sub == null) {
                    sub = new ConjunctionMatchesIterator.SingletonMatchesIterator(matchesIterator);
                }
                subMatches.add((MatchesIterator)sub);
            }
            return MatchesUtils.disjunction(subMatches);
        }

        public Query getQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int gaps() {
            int width = this.endPosition() - this.startPosition() + 1;
            for (MatchesIterator matchesIterator : this.subs) {
                width -= matchesIterator.endPosition() - matchesIterator.startPosition() + 1;
            }
            return width;
        }

        @Override
        public int width() {
            int width = 0;
            for (MatchesIterator matchesIterator : this.subs) {
                width += matchesIterator.endPosition() - matchesIterator.startPosition() + 1;
            }
            return width;
        }
    }
}

