/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalClusterUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterHealthAction
extends TransportMasterNodeReadAction<ClusterHealthRequest, ClusterHealthResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterHealthAction.class);
    private final AllocationService allocationService;

    @Inject
    public TransportClusterHealthAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationService allocationService) {
        super("cluster:monitor/health", false, transportService, clusterService, threadPool, actionFilters, ClusterHealthRequest::new, indexNameExpressionResolver, ClusterHealthResponse::new, "same");
        this.allocationService = allocationService;
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterHealthRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void masterOperation(Task task, ClusterHealthRequest request, ClusterState unusedState, ActionListener<ClusterHealthResponse> listener) {
        int waitCount = TransportClusterHealthAction.getWaitCount(request);
        if (request.waitForEvents() != null) {
            this.waitForEventsAndExecuteHealth(request, listener, waitCount, this.threadPool.relativeTimeInMillis() + request.timeout().millis());
        } else {
            this.executeHealth(request, this.clusterService.state(), listener, waitCount, clusterState -> listener.onResponse(this.getResponse(request, (ClusterState)clusterState, waitCount, TimeoutState.OK)));
        }
    }

    private void waitForEventsAndExecuteHealth(final ClusterHealthRequest request, final ActionListener<ClusterHealthResponse> listener, final int waitCount, final long endTimeRelativeMillis) {
        assert (request.waitForEvents() != null);
        if (request.local()) {
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + request.waitForEvents() + "])", new LocalClusterUpdateTask(request.waitForEvents()){

                @Override
                public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) {
                    return 1.unchanged();
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTimeRelativeMillis - TransportClusterHealthAction.this.threadPool.relativeTimeInMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                    request.timeout(newTimeout);
                    TransportClusterHealthAction.this.executeHealth(request, TransportClusterHealthAction.this.clusterService.state(), listener, waitCount, observedState -> TransportClusterHealthAction.this.waitForEventsAndExecuteHealth(request, listener, waitCount, endTimeRelativeMillis));
                }

                @Override
                public void onFailure(String source, Exception e) {
                    logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    listener.onFailure(e);
                }
            });
        } else {
            TimeValue taskTimeout = TimeValue.timeValueMillis((long)Math.max(0L, endTimeRelativeMillis - this.threadPool.relativeTimeInMillis()));
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + request.waitForEvents() + "])", new ClusterStateUpdateTask(request.waitForEvents(), taskTimeout){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTimeRelativeMillis - TransportClusterHealthAction.this.threadPool.relativeTimeInMillis());
                    TimeValue newTimeout = TimeValue.timeValueMillis((long)timeoutInMillis);
                    request.timeout(newTimeout);
                    ClusterState appliedState = TransportClusterHealthAction.this.clusterService.state();
                    assert (newState.stateUUID().equals(appliedState.stateUUID())) : newState.stateUUID() + " vs " + appliedState.stateUUID();
                    TransportClusterHealthAction.this.executeHealth(request, appliedState, listener, waitCount, observedState -> TransportClusterHealthAction.this.waitForEventsAndExecuteHealth(request, listener, waitCount, endTimeRelativeMillis));
                }

                @Override
                public void onNoLongerMaster(String source) {
                    logger.trace("stopped being master while waiting for events with priority [{}]. retrying.", (Object)request.waitForEvents());
                    listener.onFailure(new NotMasterException("no longer master. source: [" + source + "]"));
                }

                @Override
                public void onFailure(String source, Exception e) {
                    if (e instanceof ProcessClusterEventTimeoutException) {
                        listener.onResponse(TransportClusterHealthAction.this.getResponse(request, TransportClusterHealthAction.this.clusterService.state(), waitCount, TimeoutState.TIMED_OUT));
                    } else {
                        logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                        listener.onFailure(e);
                    }
                }
            });
        }
    }

    private void executeHealth(final ClusterHealthRequest request, ClusterState currentState, final ActionListener<ClusterHealthResponse> listener, final int waitCount, final Consumer<ClusterState> onNewClusterStateAfterDelay) {
        if (request.timeout().millis() == 0L) {
            listener.onResponse(this.getResponse(request, currentState, waitCount, TimeoutState.ZERO_TIMEOUT));
            return;
        }
        Predicate<ClusterState> validationPredicate = newState -> this.validateRequest(request, (ClusterState)newState, waitCount);
        if (validationPredicate.test(currentState)) {
            listener.onResponse(this.getResponse(request, currentState, waitCount, TimeoutState.OK));
        } else {
            final ClusterStateObserver observer = new ClusterStateObserver(currentState, this.clusterService, null, logger, this.threadPool.getThreadContext());
            ClusterStateObserver.Listener stateListener = new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState newState) {
                    onNewClusterStateAfterDelay.accept(newState);
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(TransportClusterHealthAction.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onResponse(TransportClusterHealthAction.this.getResponse(request, observer.setAndGetObservedState(), waitCount, TimeoutState.TIMED_OUT));
                }
            };
            observer.waitForNextChange(stateListener, validationPredicate, request.timeout());
        }
    }

    private static int getWaitCount(ClusterHealthRequest request) {
        int waitCount = 0;
        if (request.waitForStatus() != null) {
            ++waitCount;
        }
        if (request.waitForNoRelocatingShards()) {
            ++waitCount;
        }
        if (request.waitForNoInitializingShards()) {
            ++waitCount;
        }
        if (!request.waitForActiveShards().equals(ActiveShardCount.NONE)) {
            ++waitCount;
        }
        if (!request.waitForNodes().isEmpty()) {
            ++waitCount;
        }
        if (!CollectionUtils.isEmpty(request.indices())) {
            ++waitCount;
        }
        return waitCount;
    }

    private boolean validateRequest(ClusterHealthRequest request, ClusterState clusterState, int waitCount) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getMasterService().numberOfPendingTasks(), this.allocationService.getNumberOfInFlightFetches(), this.clusterService.getMasterService().getMaxTaskWaitTime());
        return TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver) == waitCount;
    }

    private ClusterHealthResponse getResponse(ClusterHealthRequest request, ClusterState clusterState, int waitFor, TimeoutState timeoutState) {
        boolean valid;
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.getMasterService().numberOfPendingTasks(), this.allocationService.getNumberOfInFlightFetches(), this.clusterService.getMasterService().getMaxTaskWaitTime());
        int readyCounter = TransportClusterHealthAction.prepareResponse(request, response, clusterState, this.indexNameExpressionResolver);
        boolean bl = valid = readyCounter == waitFor;
        assert (valid || timeoutState != TimeoutState.OK);
        response.setTimedOut(!valid || timeoutState == TimeoutState.TIMED_OUT);
        return response;
    }

    static int prepareResponse(ClusterHealthRequest request, ClusterHealthResponse response, ClusterState clusterState, IndexNameExpressionResolver indexNameExpressionResolver) {
        int waitForCounter = 0;
        if (request.waitForStatus() != null && response.getStatus().value() <= request.waitForStatus().value()) {
            ++waitForCounter;
        }
        if (request.waitForNoRelocatingShards() && response.getRelocatingShards() == 0) {
            ++waitForCounter;
        }
        if (request.waitForNoInitializingShards() && response.getInitializingShards() == 0) {
            ++waitForCounter;
        }
        if (!request.waitForActiveShards().equals(ActiveShardCount.NONE)) {
            ActiveShardCount waitForActiveShards = request.waitForActiveShards();
            assert (!waitForActiveShards.equals(ActiveShardCount.DEFAULT)) : "waitForActiveShards must not be DEFAULT on the request object, instead it should be NONE";
            if (waitForActiveShards.equals(ActiveShardCount.ALL)) {
                if (response.getUnassignedShards() == 0 && response.getInitializingShards() == 0) {
                    ++waitForCounter;
                }
            } else if (waitForActiveShards.enoughShardsActive(response.getActiveShards())) {
                ++waitForCounter;
            }
        }
        if (!CollectionUtils.isEmpty(request.indices())) {
            try {
                indexNameExpressionResolver.concreteIndexNames(clusterState, IndicesOptions.strictExpand(), request);
                ++waitForCounter;
            }
            catch (IndexNotFoundException e) {
                response.setStatus(ClusterHealthStatus.RED);
            }
        }
        if (!request.waitForNodes().isEmpty()) {
            if (request.waitForNodes().startsWith(">=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("ge(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("le(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith(">")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("gt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("lt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else {
                int expected = Integer.parseInt(request.waitForNodes());
                if (response.getNumberOfNodes() == expected) {
                    ++waitForCounter;
                }
            }
        }
        return waitForCounter;
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, TimeValue pendingTaskTimeInQueue) {
        String[] concreteIndices;
        if (logger.isTraceEnabled()) {
            logger.trace("Calculating health based on state version [{}]", (Object)clusterState.version());
        }
        try {
            concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, request);
        }
        catch (IndexNotFoundException e) {
            ClusterHealthResponse response = new ClusterHealthResponse(clusterState.getClusterName().value(), Strings.EMPTY_ARRAY, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue, request.doesReturn200ForClusterHealthTimeout());
            response.setStatus(ClusterHealthStatus.RED);
            return response;
        }
        return new ClusterHealthResponse(clusterState.getClusterName().value(), concreteIndices, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue, request.doesReturn200ForClusterHealthTimeout());
    }

    private static enum TimeoutState {
        OK,
        TIMED_OUT,
        ZERO_TIMEOUT;

    }
}

