/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class PutPipelineRequest
extends AcknowledgedRequest<PutPipelineRequest>
implements ToXContentObject {
    private final String id;
    private final BytesReference source;
    private final XContentType xContentType;
    private final Integer version;

    public PutPipelineRequest(String id, BytesReference source, XContentType xContentType, Integer version) {
        this.id = Objects.requireNonNull(id);
        this.source = Objects.requireNonNull(source);
        this.xContentType = Objects.requireNonNull(xContentType);
        this.version = version;
    }

    public PutPipelineRequest(String id, BytesReference source, XContentType xContentType) {
        this(id, source, xContentType, null);
    }

    public PutPipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.xContentType = in.readEnum(XContentType.class);
        this.version = in.getVersion().onOrAfter(Version.V_7_16_0) ? in.readOptionalInt() : null;
    }

    PutPipelineRequest() {
        this(null, null, null, null);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public XContentType getXContentType() {
        return this.xContentType;
    }

    public Integer getVersion() {
        return this.version;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        XContentHelper.writeTo(out, this.xContentType);
        if (out.getVersion().onOrAfter(Version.V_7_16_0)) {
            out.writeOptionalInt(this.version);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source != null) {
            builder.rawValue((InputStream)this.source.streamInput(), this.xContentType);
        } else {
            builder.startObject().endObject();
        }
        return builder;
    }
}

