/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.elasticsearch.env.Environment;

public class ConsoleLoader {
    private static final String CONSOLE_LOADER_CLASS = "org.elasticsearch.io.ansi.AnsiConsoleLoader";

    public static PrintStream loadConsole(Environment env) {
        ClassLoader classLoader = ConsoleLoader.buildClassLoader(env);
        Supplier<PrintStream> supplier = ConsoleLoader.buildConsoleLoader(classLoader);
        return supplier.get();
    }

    static Supplier<PrintStream> buildConsoleLoader(ClassLoader classLoader) {
        try {
            Class<?> cls = classLoader.loadClass(CONSOLE_LOADER_CLASS);
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            Supplier supplier = (Supplier)constructor.newInstance(new Object[0]);
            return supplier;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to load ANSI console", e);
        }
    }

    private static ClassLoader buildClassLoader(Environment env) {
        Path libDir = env.libFile().resolve("tools").resolve("ansi-console");
        try {
            URL[] urls = (URL[])Files.list(libDir).filter(each -> each.getFileName().toString().endsWith(".jar")).map(ConsoleLoader::pathToURL).toArray(URL[]::new);
            return URLClassLoader.newInstance(urls, ConsoleLoader.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to list jars in [" + libDir + "]: " + e.getMessage(), e);
        }
    }

    private static URL pathToURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to convert path [" + path + "] to URL", e);
        }
    }
}

