/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.compress.DeflateCompressor;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public final class CompressedXContent {
    private static final ThreadLocal<InflaterAndBuffer> inflater1 = ThreadLocal.withInitial(() -> new InflaterAndBuffer());
    private static final ThreadLocal<InflaterAndBuffer> inflater2 = ThreadLocal.withInitial(() -> new InflaterAndBuffer());
    private final byte[] bytes;
    private final int crc32;

    private static int crc32(BytesReference data) {
        CRC32 crc32 = new CRC32();
        try {
            data.writeTo(new CheckedOutputStream(Streams.NULL_OUTPUT_STREAM, crc32));
        }
        catch (IOException bogus) {
            throw new Error(bogus);
        }
        return (int)crc32.getValue();
    }

    private static int crc32FromCompressed(byte[] compressed) {
        CRC32 crc32 = new CRC32();
        InflaterAndBuffer inflaterAndBuffer = inflater1.get();
        try {
            Inflater inflater = inflaterAndBuffer.inflater;
            ByteBuffer buffer = inflaterAndBuffer.buffer;
            assert (CompressedXContent.assertBufferIsCleared(buffer));
            CompressedXContent.setInflaterInput(compressed, inflater);
            do {
                if (inflater.inflate(buffer) > 0) {
                    crc32.update(buffer.flip());
                }
                buffer.clear();
            } while (!inflater.finished());
            int n = (int)crc32.getValue();
            if (inflaterAndBuffer != null) {
                inflaterAndBuffer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (inflaterAndBuffer != null) {
                    try {
                        inflaterAndBuffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (DataFormatException e) {
                throw new ElasticsearchException(e);
            }
        }
    }

    private CompressedXContent(byte[] compressed, int crc32) {
        this.bytes = compressed;
        this.crc32 = crc32;
        this.assertConsistent();
    }

    public CompressedXContent(ToXContent xcontent, XContentType type, ToXContent.Params params) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        CRC32 crc32 = new CRC32();
        CheckedOutputStream checkedStream = new CheckedOutputStream(CompressorFactory.COMPRESSOR.threadLocalOutputStream(bStream), crc32);
        try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)type, (OutputStream)checkedStream);){
            if (xcontent.isFragment()) {
                builder.startObject();
            }
            xcontent.toXContent(builder, params);
            if (xcontent.isFragment()) {
                builder.endObject();
            }
        }
        this.bytes = BytesReference.toBytes(bStream.bytes());
        this.crc32 = (int)crc32.getValue();
        this.assertConsistent();
    }

    public CompressedXContent(BytesReference data) throws IOException {
        Compressor compressor = CompressorFactory.compressor(data);
        if (compressor != null) {
            this.bytes = BytesReference.toBytes(data);
            this.crc32 = CompressedXContent.crc32FromCompressed(this.bytes);
        } else {
            this.bytes = BytesReference.toBytes(CompressorFactory.COMPRESSOR.compress(data));
            this.crc32 = CompressedXContent.crc32(data);
        }
        this.assertConsistent();
    }

    private void assertConsistent() {
        assert (CompressorFactory.compressor(new BytesArray(this.bytes)) != null);
        assert (this.crc32 == CompressedXContent.crc32(this.uncompressed()));
        assert (this.crc32 == CompressedXContent.crc32FromCompressed(this.bytes));
    }

    public CompressedXContent(byte[] data) throws IOException {
        this(new BytesArray(data));
    }

    public CompressedXContent(String str) throws IOException {
        this(new BytesArray(str.getBytes(StandardCharsets.UTF_8)));
    }

    public byte[] compressed() {
        return this.bytes;
    }

    public BytesReference compressedReference() {
        return new BytesArray(this.bytes);
    }

    public BytesReference uncompressed() {
        try {
            return CompressorFactory.uncompress(new BytesArray(this.bytes));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot decompress compressed string", e);
        }
    }

    public String string() {
        return this.uncompressed().utf8ToString();
    }

    public static CompressedXContent readCompressedString(StreamInput in) throws IOException {
        int crc32 = in.readInt();
        return new CompressedXContent(in.readByteArray(), crc32);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.crc32);
        out.writeByteArray(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressedXContent that = (CompressedXContent)o;
        if (this.crc32 != that.crc32) {
            return false;
        }
        if (Arrays.equals(this.bytes, that.bytes)) {
            return true;
        }
        return CompressedXContent.equalsWhenUncompressed(this.bytes, that.bytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean equalsWhenUncompressed(byte[] compressed1, byte[] compressed2) {
        try (InflaterAndBuffer inflaterAndBuffer1 = inflater1.get();
             InflaterAndBuffer inflaterAndBuffer2 = inflater2.get();){
            Inflater inf1 = inflaterAndBuffer1.inflater;
            Inflater inf2 = inflaterAndBuffer2.inflater;
            CompressedXContent.setInflaterInput(compressed1, inf1);
            CompressedXContent.setInflaterInput(compressed2, inf2);
            ByteBuffer buf1 = inflaterAndBuffer1.buffer;
            assert (CompressedXContent.assertBufferIsCleared(buf1));
            ByteBuffer buf2 = inflaterAndBuffer2.buffer;
            assert (CompressedXContent.assertBufferIsCleared(buf2));
            while (true) {
                if (inf1.inflate(buf1) > 0 && buf1.hasRemaining()) {
                    continue;
                }
                while (inf2.inflate(buf2) > 0 && buf2.hasRemaining()) {
                }
                if (!buf1.flip().equals(buf2.flip())) {
                    boolean bl = false;
                    return bl;
                }
                if (inf1.finished()) {
                    boolean bl = inf2.finished();
                    return bl;
                }
                buf1.clear();
                buf2.clear();
            }
        }
        catch (DataFormatException e) {
            throw new ElasticsearchException(e);
        }
    }

    public int hashCode() {
        return this.crc32;
    }

    public String toString() {
        return this.string();
    }

    private static void setInflaterInput(byte[] compressed, Inflater inflater) {
        inflater.setInput(compressed, DeflateCompressor.HEADER_SIZE, compressed.length - DeflateCompressor.HEADER_SIZE);
    }

    private static boolean assertBufferIsCleared(ByteBuffer buffer) {
        assert (buffer.limit() == buffer.capacity()) : "buffer limit != capacity, was [" + buffer.limit() + "] and [" + buffer.capacity() + "]";
        assert (buffer.position() == 0) : "buffer position != 0, was [" + buffer.position() + "]";
        return true;
    }

    private static final class InflaterAndBuffer
    implements Releasable {
        final ByteBuffer buffer = ByteBuffer.allocate(4096);
        final Inflater inflater = new Inflater(true);

        private InflaterAndBuffer() {
        }

        public void close() {
            this.inflater.reset();
            this.buffer.clear();
        }
    }
}

