/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FloatArray;

final class BigFloatArray
extends AbstractBigArray
implements FloatArray {
    private static final BigFloatArray ESTIMATOR = new BigFloatArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    static final VarHandle VH_PLATFORM_NATIVE_FLOAT = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.nativeOrder());
    private byte[][] pages;

    BigFloatArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(4096, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new byte[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newBytePage(i);
        }
    }

    @Override
    public float set(long index, float value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = this.pages[pageIndex];
        float ret = VH_PLATFORM_NATIVE_FLOAT.get(page, indexInPage << 2);
        VH_PLATFORM_NATIVE_FLOAT.set(page, indexInPage << 2, value);
        return ret;
    }

    @Override
    public float increment(long index, float inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = this.pages[pageIndex];
        float newVal = VH_PLATFORM_NATIVE_FLOAT.get(page, indexInPage << 2) + inc;
        VH_PLATFORM_NATIVE_FLOAT.set(page, indexInPage << 2, newVal);
        return newVal;
    }

    @Override
    public float get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return VH_PLATFORM_NATIVE_FLOAT.get(this.pages[pageIndex], indexInPage << 2);
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (byte[][])Arrays.copyOf(this.pages, ArrayUtil.oversize((int)numPages, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newBytePage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    @Override
    public void fill(long fromIndex, long toIndex, float value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            BigFloatArray.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            BigFloatArray.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pageSize(), value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                BigFloatArray.fill(this.pages[i], 0, this.pageSize(), value);
            }
            BigFloatArray.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }

    public static void fill(byte[] page, int from, int to, float value) {
        if (from < to) {
            VH_PLATFORM_NATIVE_FLOAT.set(page, from << 2, value);
            BigFloatArray.fillBySelfCopy(page, from << 2, to << 2, 4);
        }
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        this.set(index, buf, offset, len, this.pages, 2);
    }
}

