/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;

final class BigIntArray
extends AbstractBigArray
implements IntArray {
    private static final BigIntArray ESTIMATOR = new BigIntArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    static final VarHandle VH_PLATFORM_NATIVE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.nativeOrder());
    private byte[][] pages;

    BigIntArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(4096, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new byte[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newBytePage(i);
        }
    }

    @Override
    public int get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return VH_PLATFORM_NATIVE_INT.get(this.pages[pageIndex], indexInPage << 2);
    }

    @Override
    public int set(long index, int value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = this.pages[pageIndex];
        int ret = VH_PLATFORM_NATIVE_INT.get(page, indexInPage << 2);
        VH_PLATFORM_NATIVE_INT.set(page, indexInPage << 2, value);
        return ret;
    }

    @Override
    public int increment(long index, int inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = this.pages[pageIndex];
        int newVal = VH_PLATFORM_NATIVE_INT.get(page, indexInPage << 2) + inc;
        VH_PLATFORM_NATIVE_INT.set(page, indexInPage << 2, newVal);
        return newVal;
    }

    @Override
    public void fill(long fromIndex, long toIndex, int value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            BigIntArray.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            BigIntArray.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pageSize(), value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                BigIntArray.fill(this.pages[i], 0, this.pageSize(), value);
            }
            BigIntArray.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }

    public static void fill(byte[] page, int from, int to, int value) {
        if (from < to) {
            VH_PLATFORM_NATIVE_INT.set(page, from << 2, value);
            BigIntArray.fillBySelfCopy(page, from << 2, to << 2, 4);
        }
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (byte[][])Arrays.copyOf(this.pages, ArrayUtil.oversize((int)numPages, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newBytePage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        this.set(index, buf, offset, len, this.pages, 2);
    }
}

