/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.StoredValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class RoutingFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_routing";
    public static final String CONTENT_TYPE = "_routing";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> RoutingFieldMapper.get(false), c -> new Builder());
    private final boolean required;
    private static final RoutingFieldMapper REQUIRED = new RoutingFieldMapper(true);
    private static final RoutingFieldMapper NOT_REQUIRED = new RoutingFieldMapper(false);

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder().init(this);
    }

    private static RoutingFieldMapper toType(FieldMapper in) {
        return (RoutingFieldMapper)in;
    }

    public static RoutingFieldMapper get(boolean required) {
        return required ? REQUIRED : NOT_REQUIRED;
    }

    private RoutingFieldMapper(boolean required) {
        super(RoutingFieldType.INSTANCE, Lucene.KEYWORD_ANALYZER);
        this.required = required;
    }

    public boolean required() {
        return this.required;
    }

    @Override
    public void preParse(DocumentParserContext context) {
        String routing = context.sourceToParse().routing();
        if (routing != null) {
            context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)routing, (IndexableFieldType)Defaults.FIELD_TYPE));
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected String contentType() {
        return "_routing";
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> required = FieldMapper.Parameter.boolParam("required", false, m -> RoutingFieldMapper.toType((FieldMapper)m).required, false);

        protected Builder() {
            super("_routing");
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return List.of(this.required);
        }

        @Override
        public RoutingFieldMapper build() {
            return RoutingFieldMapper.get(this.required.getValue());
        }
    }

    static final class RoutingFieldType
    extends StringFieldType {
        static RoutingFieldType INSTANCE = new RoutingFieldType();

        private RoutingFieldType() {
            super("_routing", true, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_routing";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new StoredValueFetcher(context.lookup(), "_routing");
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final boolean REQUIRED = false;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

